/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteExpressionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteExpressionRequest> {
    private final String domainName;
    private final String expressionName;

    private DeleteExpressionRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.expressionName = builder.expressionName;
    }

    public String domainName() {
        return this.domainName;
    }

    public String expressionName() {
        return this.expressionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.expressionName() == null ? 0 : this.expressionName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteExpressionRequest)) {
            return false;
        }
        DeleteExpressionRequest other = (DeleteExpressionRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.expressionName() == null ^ this.expressionName() == null) {
            return false;
        }
        return other.expressionName() == null || other.expressionName().equals(this.expressionName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.expressionName() != null) {
            sb.append("ExpressionName: ").append(this.expressionName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "ExpressionName": {
                return Optional.of(clazz.cast(this.expressionName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String expressionName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteExpressionRequest model) {
            this.domainName(model.domainName);
            this.expressionName(model.expressionName);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getExpressionName() {
            return this.expressionName;
        }

        @Override
        public final Builder expressionName(String expressionName) {
            this.expressionName = expressionName;
            return this;
        }

        public final void setExpressionName(String expressionName) {
            this.expressionName = expressionName;
        }

        public DeleteExpressionRequest build() {
            return new DeleteExpressionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteExpressionRequest> {
        public Builder domainName(String var1);

        public Builder expressionName(String var1);
    }
}

