/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse;
import software.amazon.awssdk.services.cloudsearchdomain.transform.BucketInfoUnmarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.FieldStatsUnmarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.HitsUnmarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.SearchStatusUnmarshaller;

public class SearchResponseUnmarshaller
implements Unmarshaller<SearchResponse, JsonUnmarshallerContext> {
    private static final SearchResponseUnmarshaller INSTANCE = new SearchResponseUnmarshaller();

    public SearchResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        SearchResponse.Builder searchResponseBuilder = SearchResponse.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return (SearchResponse)((Object)searchResponseBuilder.build());
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    searchResponseBuilder.status(SearchStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("hits", targetDepth)) {
                    context.nextToken();
                    searchResponseBuilder.hits(HitsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("facets", targetDepth)) {
                    context.nextToken();
                    searchResponseBuilder.facets(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)BucketInfoUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("stats", targetDepth)) {
                    context.nextToken();
                    searchResponseBuilder.stats(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)FieldStatsUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SearchResponse)((Object)searchResponseBuilder.build());
    }

    public static SearchResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

