/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.Suggester;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefineSuggesterRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, DefineSuggesterRequest> {
    private final String domainName;
    private final Suggester suggester;

    private DefineSuggesterRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.suggester = builder.suggester;
    }

    public String domainName() {
        return this.domainName;
    }

    public Suggester suggester() {
        return this.suggester;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggester());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefineSuggesterRequest)) {
            return false;
        }
        DefineSuggesterRequest other = (DefineSuggesterRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.suggester(), other.suggester());
    }

    public String toString() {
        return ToString.builder((String)"DefineSuggesterRequest").add("DomainName", (Object)this.domainName()).add("Suggester", (Object)this.suggester()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Suggester": {
                return Optional.ofNullable(clazz.cast(this.suggester()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private Suggester suggester;

        private BuilderImpl() {
        }

        private BuilderImpl(DefineSuggesterRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.suggester(model.suggester);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Suggester.Builder getSuggester() {
            return this.suggester != null ? this.suggester.toBuilder() : null;
        }

        @Override
        public final Builder suggester(Suggester suggester) {
            this.suggester = suggester;
            return this;
        }

        public final void setSuggester(Suggester.BuilderImpl suggester) {
            this.suggester = suggester != null ? suggester.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DefineSuggesterRequest build() {
            return new DefineSuggesterRequest(this);
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    CopyableBuilder<Builder, DefineSuggesterRequest> {
        public Builder domainName(String var1);

        public Builder suggester(Suggester var1);

        default public Builder suggester(Consumer<Suggester.Builder> suggester) {
            return this.suggester((Suggester)((Suggester.Builder)Suggester.builder().applyMutation(suggester)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

