/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsRequest;

public class DescribeIndexFieldsRequestMarshaller
implements Marshaller<Request<DescribeIndexFieldsRequest>, DescribeIndexFieldsRequest> {
    public Request<DescribeIndexFieldsRequest> marshall(DescribeIndexFieldsRequest describeIndexFieldsRequest) {
        List<String> fieldNamesList;
        if (describeIndexFieldsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeIndexFieldsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeIndexFields");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeIndexFieldsRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeIndexFieldsRequest.domainName()));
        }
        if ((fieldNamesList = describeIndexFieldsRequest.fieldNames()) != null) {
            if (!fieldNamesList.isEmpty()) {
                int fieldNamesListIndex = 1;
                for (String fieldNamesListValue : fieldNamesList) {
                    if (fieldNamesListValue != null) {
                        request.addParameter("FieldNames.member." + fieldNamesListIndex, StringUtils.fromString((String)fieldNamesListValue));
                    }
                    ++fieldNamesListIndex;
                }
            } else {
                request.addParameter("FieldNames", "");
            }
        }
        if (describeIndexFieldsRequest.deployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeIndexFieldsRequest.deployed()));
        }
        return request;
    }
}

