/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.ScalingParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateScalingParametersRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, UpdateScalingParametersRequest> {
    private final String domainName;
    private final ScalingParameters scalingParameters;

    private UpdateScalingParametersRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.scalingParameters = builder.scalingParameters;
    }

    public String domainName() {
        return this.domainName;
    }

    public ScalingParameters scalingParameters() {
        return this.scalingParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScalingParametersRequest)) {
            return false;
        }
        UpdateScalingParametersRequest other = (UpdateScalingParametersRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.scalingParameters(), other.scalingParameters());
    }

    public String toString() {
        return ToString.builder((String)"UpdateScalingParametersRequest").add("DomainName", (Object)this.domainName()).add("ScalingParameters", (Object)this.scalingParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "ScalingParameters": {
                return Optional.of(clazz.cast(this.scalingParameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private ScalingParameters scalingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScalingParametersRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.scalingParameters(model.scalingParameters);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ScalingParameters.Builder getScalingParameters() {
            return this.scalingParameters != null ? this.scalingParameters.toBuilder() : null;
        }

        @Override
        public final Builder scalingParameters(ScalingParameters scalingParameters) {
            this.scalingParameters = scalingParameters;
            return this;
        }

        public final void setScalingParameters(ScalingParameters.BuilderImpl scalingParameters) {
            this.scalingParameters = scalingParameters != null ? scalingParameters.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateScalingParametersRequest build() {
            return new UpdateScalingParametersRequest(this);
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    CopyableBuilder<Builder, UpdateScalingParametersRequest> {
        public Builder domainName(String var1);

        public Builder scalingParameters(ScalingParameters var1);

        default public Builder scalingParameters(Consumer<ScalingParameters.Builder> scalingParameters) {
            return this.scalingParameters((ScalingParameters)((ScalingParameters.Builder)ScalingParameters.builder().apply(scalingParameters)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

