/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.StandardNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeExpressionsRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, DescribeExpressionsRequest> {
    private final String domainName;
    private final List<String> expressionNames;
    private final Boolean deployed;

    private DescribeExpressionsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.expressionNames = builder.expressionNames;
        this.deployed = builder.deployed;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> expressionNames() {
        return this.expressionNames;
    }

    public Boolean deployed() {
        return this.deployed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExpressionsRequest)) {
            return false;
        }
        DescribeExpressionsRequest other = (DescribeExpressionsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.expressionNames(), other.expressionNames()) && Objects.equals(this.deployed(), other.deployed());
    }

    public String toString() {
        return ToString.builder((String)"DescribeExpressionsRequest").add("DomainName", (Object)this.domainName()).add("ExpressionNames", this.expressionNames()).add("Deployed", (Object)this.deployed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "ExpressionNames": {
                return Optional.of(clazz.cast(this.expressionNames()));
            }
            case "Deployed": {
                return Optional.of(clazz.cast(this.deployed()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> expressionNames;
        private Boolean deployed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExpressionsRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.expressionNames(model.expressionNames);
            this.deployed(model.deployed);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getExpressionNames() {
            return this.expressionNames;
        }

        @Override
        public final Builder expressionNames(Collection<String> expressionNames) {
            this.expressionNames = StandardNameListCopier.copy(expressionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expressionNames(String ... expressionNames) {
            this.expressionNames(Arrays.asList(expressionNames));
            return this;
        }

        public final void setExpressionNames(Collection<String> expressionNames) {
            this.expressionNames = StandardNameListCopier.copy(expressionNames);
        }

        public final Boolean getDeployed() {
            return this.deployed;
        }

        @Override
        public final Builder deployed(Boolean deployed) {
            this.deployed = deployed;
            return this;
        }

        public final void setDeployed(Boolean deployed) {
            this.deployed = deployed;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeExpressionsRequest build() {
            return new DescribeExpressionsRequest(this);
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    CopyableBuilder<Builder, DescribeExpressionsRequest> {
        public Builder domainName(String var1);

        public Builder expressionNames(Collection<String> var1);

        public Builder expressionNames(String ... var1);

        public Builder deployed(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

