/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.IndexField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DefineIndexFieldRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, DefineIndexFieldRequest> {
    private final String domainName;
    private final IndexField indexField;

    private DefineIndexFieldRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.indexField = builder.indexField;
    }

    public String domainName() {
        return this.domainName;
    }

    public IndexField indexField() {
        return this.indexField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexField());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefineIndexFieldRequest)) {
            return false;
        }
        DefineIndexFieldRequest other = (DefineIndexFieldRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.indexField(), other.indexField());
    }

    public String toString() {
        return ToString.builder((String)"DefineIndexFieldRequest").add("DomainName", (Object)this.domainName()).add("IndexField", (Object)this.indexField()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "IndexField": {
                return Optional.of(clazz.cast(this.indexField()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private IndexField indexField;

        private BuilderImpl() {
        }

        private BuilderImpl(DefineIndexFieldRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.indexField(model.indexField);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final IndexField.Builder getIndexField() {
            return this.indexField != null ? this.indexField.toBuilder() : null;
        }

        @Override
        public final Builder indexField(IndexField indexField) {
            this.indexField = indexField;
            return this;
        }

        public final void setIndexField(IndexField.BuilderImpl indexField) {
            this.indexField = indexField != null ? indexField.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DefineIndexFieldRequest build() {
            return new DefineIndexFieldRequest(this);
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    CopyableBuilder<Builder, DefineIndexFieldRequest> {
        public Builder domainName(String var1);

        public Builder indexField(IndexField var1);

        default public Builder indexField(Consumer<IndexField.Builder> indexField) {
            return this.indexField((IndexField)((IndexField.Builder)IndexField.builder().apply(indexField)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

