/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeIndexFieldsRequestMarshaller
implements Marshaller<Request<DescribeIndexFieldsRequest>, DescribeIndexFieldsRequest> {
    public Request<DescribeIndexFieldsRequest> marshall(DescribeIndexFieldsRequest describeIndexFieldsRequest) {
        SdkInternalList fieldNamesList;
        if (describeIndexFieldsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeIndexFieldsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeIndexFields");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeIndexFieldsRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeIndexFieldsRequest.domainName()));
        }
        if (!(fieldNamesList = (SdkInternalList)describeIndexFieldsRequest.fieldNames()).isEmpty() || !fieldNamesList.isAutoConstruct()) {
            int fieldNamesListIndex = 1;
            for (String fieldNamesListValue : fieldNamesList) {
                if (fieldNamesListValue != null) {
                    request.addParameter("FieldNames.member." + fieldNamesListIndex, StringUtils.fromString((String)fieldNamesListValue));
                }
                ++fieldNamesListIndex;
            }
        }
        if (describeIndexFieldsRequest.deployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeIndexFieldsRequest.deployed()));
        }
        return request;
    }
}

