/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import software.amazon.awssdk.services.cloudsearch.model.AnalysisOptions;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisSchemeLanguage;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AnalysisScheme
implements ToCopyableBuilder<Builder, AnalysisScheme> {
    private final String analysisSchemeName;
    private final String analysisSchemeLanguage;
    private final AnalysisOptions analysisOptions;

    private AnalysisScheme(BuilderImpl builder) {
        this.analysisSchemeName = builder.analysisSchemeName;
        this.analysisSchemeLanguage = builder.analysisSchemeLanguage;
        this.analysisOptions = builder.analysisOptions;
    }

    public String analysisSchemeName() {
        return this.analysisSchemeName;
    }

    public String analysisSchemeLanguage() {
        return this.analysisSchemeLanguage;
    }

    public AnalysisOptions analysisOptions() {
        return this.analysisOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.analysisSchemeName() == null ? 0 : this.analysisSchemeName().hashCode());
        hashCode = 31 * hashCode + (this.analysisSchemeLanguage() == null ? 0 : this.analysisSchemeLanguage().hashCode());
        hashCode = 31 * hashCode + (this.analysisOptions() == null ? 0 : this.analysisOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisScheme)) {
            return false;
        }
        AnalysisScheme other = (AnalysisScheme)obj;
        if (other.analysisSchemeName() == null ^ this.analysisSchemeName() == null) {
            return false;
        }
        if (other.analysisSchemeName() != null && !other.analysisSchemeName().equals(this.analysisSchemeName())) {
            return false;
        }
        if (other.analysisSchemeLanguage() == null ^ this.analysisSchemeLanguage() == null) {
            return false;
        }
        if (other.analysisSchemeLanguage() != null && !other.analysisSchemeLanguage().equals(this.analysisSchemeLanguage())) {
            return false;
        }
        if (other.analysisOptions() == null ^ this.analysisOptions() == null) {
            return false;
        }
        return other.analysisOptions() == null || other.analysisOptions().equals(this.analysisOptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.analysisSchemeName() != null) {
            sb.append("AnalysisSchemeName: ").append(this.analysisSchemeName()).append(",");
        }
        if (this.analysisSchemeLanguage() != null) {
            sb.append("AnalysisSchemeLanguage: ").append(this.analysisSchemeLanguage()).append(",");
        }
        if (this.analysisOptions() != null) {
            sb.append("AnalysisOptions: ").append(this.analysisOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String analysisSchemeName;
        private String analysisSchemeLanguage;
        private AnalysisOptions analysisOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisScheme model) {
            this.setAnalysisSchemeName(model.analysisSchemeName);
            this.setAnalysisSchemeLanguage(model.analysisSchemeLanguage);
            this.setAnalysisOptions(model.analysisOptions);
        }

        public final String getAnalysisSchemeName() {
            return this.analysisSchemeName;
        }

        @Override
        public final Builder analysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
            return this;
        }

        public final void setAnalysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
        }

        public final String getAnalysisSchemeLanguage() {
            return this.analysisSchemeLanguage;
        }

        @Override
        public final Builder analysisSchemeLanguage(String analysisSchemeLanguage) {
            this.analysisSchemeLanguage = analysisSchemeLanguage;
            return this;
        }

        @Override
        public final Builder analysisSchemeLanguage(AnalysisSchemeLanguage analysisSchemeLanguage) {
            this.analysisSchemeLanguage(analysisSchemeLanguage.toString());
            return this;
        }

        public final void setAnalysisSchemeLanguage(String analysisSchemeLanguage) {
            this.analysisSchemeLanguage = analysisSchemeLanguage;
        }

        public final void setAnalysisSchemeLanguage(AnalysisSchemeLanguage analysisSchemeLanguage) {
            this.analysisSchemeLanguage(analysisSchemeLanguage.toString());
        }

        public final AnalysisOptions getAnalysisOptions() {
            return this.analysisOptions;
        }

        @Override
        public final Builder analysisOptions(AnalysisOptions analysisOptions) {
            this.analysisOptions = analysisOptions;
            return this;
        }

        public final void setAnalysisOptions(AnalysisOptions analysisOptions) {
            this.analysisOptions = analysisOptions;
        }

        public AnalysisScheme build() {
            return new AnalysisScheme(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AnalysisScheme> {
        public Builder analysisSchemeName(String var1);

        public Builder analysisSchemeLanguage(String var1);

        public Builder analysisSchemeLanguage(AnalysisSchemeLanguage var1);

        public Builder analysisOptions(AnalysisOptions var1);
    }
}

