/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsmv2.model.HsmState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Hsm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Hsm> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(Hsm.getter(Hsm::availabilityZone)).setter(Hsm.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(Hsm.getter(Hsm::clusterId)).setter(Hsm.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(Hsm.getter(Hsm::subnetId)).setter(Hsm.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> ENI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EniId").getter(Hsm.getter(Hsm::eniId)).setter(Hsm.setter(Builder::eniId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniId").build()}).build();
    private static final SdkField<String> ENI_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EniIp").getter(Hsm.getter(Hsm::eniIp)).setter(Hsm.setter(Builder::eniIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniIp").build()}).build();
    private static final SdkField<String> HSM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmId").getter(Hsm.getter(Hsm::hsmId)).setter(Hsm.setter(Builder::hsmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Hsm.getter(Hsm::stateAsString)).setter(Hsm.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateMessage").getter(Hsm.getter(Hsm::stateMessage)).setter(Hsm.setter(Builder::stateMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, CLUSTER_ID_FIELD, SUBNET_ID_FIELD, ENI_ID_FIELD, ENI_IP_FIELD, HSM_ID_FIELD, STATE_FIELD, STATE_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Hsm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String clusterId;
    private final String subnetId;
    private final String eniId;
    private final String eniIp;
    private final String hsmId;
    private final String state;
    private final String stateMessage;

    private Hsm(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.clusterId = builder.clusterId;
        this.subnetId = builder.subnetId;
        this.eniId = builder.eniId;
        this.eniIp = builder.eniIp;
        this.hsmId = builder.hsmId;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String eniId() {
        return this.eniId;
    }

    public final String eniIp() {
        return this.eniIp;
    }

    public final String hsmId() {
        return this.hsmId;
    }

    public final HsmState state() {
        return HsmState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateMessage() {
        return this.stateMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hsm)) {
            return false;
        }
        Hsm other = (Hsm)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.eniId(), other.eniId()) && Objects.equals(this.eniIp(), other.eniIp()) && Objects.equals(this.hsmId(), other.hsmId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateMessage(), other.stateMessage());
    }

    public final String toString() {
        return ToString.builder((String)"Hsm").add("AvailabilityZone", (Object)this.availabilityZone()).add("ClusterId", (Object)this.clusterId()).add("SubnetId", (Object)this.subnetId()).add("EniId", (Object)this.eniId()).add("EniIp", (Object)this.eniIp()).add("HsmId", (Object)this.hsmId()).add("State", (Object)this.stateAsString()).add("StateMessage", (Object)this.stateMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "EniId": {
                return Optional.ofNullable(clazz.cast(this.eniId()));
            }
            case "EniIp": {
                return Optional.ofNullable(clazz.cast(this.eniIp()));
            }
            case "HsmId": {
                return Optional.ofNullable(clazz.cast(this.hsmId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateMessage": {
                return Optional.ofNullable(clazz.cast(this.stateMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("EniId", ENI_ID_FIELD);
        map.put("EniIp", ENI_IP_FIELD);
        map.put("HsmId", HSM_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Hsm, T> g) {
        return obj -> g.apply((Hsm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String clusterId;
        private String subnetId;
        private String eniId;
        private String eniIp;
        private String hsmId;
        private String state;
        private String stateMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Hsm model) {
            this.availabilityZone(model.availabilityZone);
            this.clusterId(model.clusterId);
            this.subnetId(model.subnetId);
            this.eniId(model.eniId);
            this.eniIp(model.eniIp);
            this.hsmId(model.hsmId);
            this.state(model.state);
            this.stateMessage(model.stateMessage);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getEniId() {
            return this.eniId;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final String getEniIp() {
            return this.eniIp;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final String getHsmId() {
            return this.hsmId;
        }

        public final void setHsmId(String hsmId) {
            this.hsmId = hsmId;
        }

        @Override
        public final Builder hsmId(String hsmId) {
            this.hsmId = hsmId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(HsmState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public Hsm build() {
            return new Hsm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Hsm> {
        public Builder availabilityZone(String var1);

        public Builder clusterId(String var1);

        public Builder subnetId(String var1);

        public Builder eniId(String var1);

        public Builder eniIp(String var1);

        public Builder hsmId(String var1);

        public Builder state(String var1);

        public Builder state(HsmState var1);

        public Builder stateMessage(String var1);
    }
}

