/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2AsyncClient;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2AsyncClientBuilder;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2ServiceClientConfiguration;
import software.amazon.awssdk.services.cloudhsmv2.DefaultCloudHsmV2AsyncClient;
import software.amazon.awssdk.services.cloudhsmv2.DefaultCloudHsmV2BaseClientBuilder;
import software.amazon.awssdk.services.cloudhsmv2.endpoints.CloudHsmV2EndpointProvider;

@SdkInternalApi
final class DefaultCloudHsmV2AsyncClientBuilder
extends DefaultCloudHsmV2BaseClientBuilder<CloudHsmV2AsyncClientBuilder, CloudHsmV2AsyncClient>
implements CloudHsmV2AsyncClientBuilder {
    DefaultCloudHsmV2AsyncClientBuilder() {
    }

    @Override
    public DefaultCloudHsmV2AsyncClientBuilder endpointProvider(CloudHsmV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudHsmV2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudHsmV2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CloudHsmV2ServiceClientConfiguration serviceClientConfiguration = CloudHsmV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCloudHsmV2AsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

