/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InitializeClusterRequest
extends CloudHsmV2Request
implements ToCopyableBuilder<Builder, InitializeClusterRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(InitializeClusterRequest.getter(InitializeClusterRequest::clusterId)).setter(InitializeClusterRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> SIGNED_CERT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignedCert").getter(InitializeClusterRequest.getter(InitializeClusterRequest::signedCert)).setter(InitializeClusterRequest.setter(Builder::signedCert)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignedCert").build()}).build();
    private static final SdkField<String> TRUST_ANCHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustAnchor").getter(InitializeClusterRequest.getter(InitializeClusterRequest::trustAnchor)).setter(InitializeClusterRequest.setter(Builder::trustAnchor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustAnchor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, SIGNED_CERT_FIELD, TRUST_ANCHOR_FIELD));
    private final String clusterId;
    private final String signedCert;
    private final String trustAnchor;

    private InitializeClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.signedCert = builder.signedCert;
        this.trustAnchor = builder.trustAnchor;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String signedCert() {
        return this.signedCert;
    }

    public String trustAnchor() {
        return this.trustAnchor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.signedCert());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustAnchor());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitializeClusterRequest)) {
            return false;
        }
        InitializeClusterRequest other = (InitializeClusterRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.signedCert(), other.signedCert()) && Objects.equals(this.trustAnchor(), other.trustAnchor());
    }

    public String toString() {
        return ToString.builder((String)"InitializeClusterRequest").add("ClusterId", (Object)this.clusterId()).add("SignedCert", (Object)this.signedCert()).add("TrustAnchor", (Object)this.trustAnchor()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "SignedCert": {
                return Optional.ofNullable(clazz.cast(this.signedCert()));
            }
            case "TrustAnchor": {
                return Optional.ofNullable(clazz.cast(this.trustAnchor()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InitializeClusterRequest, T> g) {
        return obj -> g.apply((InitializeClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmV2Request.BuilderImpl
    implements Builder {
        private String clusterId;
        private String signedCert;
        private String trustAnchor;

        private BuilderImpl() {
        }

        private BuilderImpl(InitializeClusterRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.signedCert(model.signedCert);
            this.trustAnchor(model.trustAnchor);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getSignedCert() {
            return this.signedCert;
        }

        @Override
        public final Builder signedCert(String signedCert) {
            this.signedCert = signedCert;
            return this;
        }

        public final void setSignedCert(String signedCert) {
            this.signedCert = signedCert;
        }

        public final String getTrustAnchor() {
            return this.trustAnchor;
        }

        @Override
        public final Builder trustAnchor(String trustAnchor) {
            this.trustAnchor = trustAnchor;
            return this;
        }

        public final void setTrustAnchor(String trustAnchor) {
            this.trustAnchor = trustAnchor;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InitializeClusterRequest build() {
            return new InitializeClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InitializeClusterRequest> {
        public Builder clusterId(String var1);

        public Builder signedCert(String var1);

        public Builder trustAnchor(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

