/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterRequest extends CloudHsmV2Request implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateClusterRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HSM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateClusterRequest::hsmType)).setter(setter(Builder::hsmType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmType").build()).build();

    private static final SdkField<String> SOURCE_BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateClusterRequest::sourceBackupId)).setter(setter(Builder::sourceBackupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupId").build()).build();

    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateClusterRequest::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD,
            HSM_TYPE_FIELD, SOURCE_BACKUP_ID_FIELD, TAG_LIST_FIELD));

    private final List<String> subnetIds;

    private final String hsmType;

    private final String sourceBackupId;

    private final List<Tag> tagList;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.subnetIds = builder.subnetIds;
        this.hsmType = builder.hsmType;
        this.sourceBackupId = builder.sourceBackupId;
        this.tagList = builder.tagList;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers (IDs) of the subnets where you are creating the cluster. You must specify at least one subnet. If
     * you specify multiple subnets, they must meet the following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All subnets must be in the same virtual private cloud (VPC).
     * </p>
     * </li>
     * <li>
     * <p>
     * You can specify only one subnet per Availability Zone.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifiers (IDs) of the subnets where you are creating the cluster. You must specify at least one
     *         subnet. If you specify multiple subnets, they must meet the following criteria:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         All subnets must be in the same virtual private cloud (VPC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can specify only one subnet per Availability Zone.
     *         </p>
     *         </li>
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The type of HSM to use in the cluster. Currently the only allowed value is <code>hsm1.medium</code>.
     * </p>
     * 
     * @return The type of HSM to use in the cluster. Currently the only allowed value is <code>hsm1.medium</code>.
     */
    public String hsmType() {
        return hsmType;
    }

    /**
     * <p>
     * The identifier (ID) of the cluster backup to restore. Use this value to restore the cluster from a backup instead
     * of creating a new cluster. To find the backup ID, use <a>DescribeBackups</a>.
     * </p>
     * 
     * @return The identifier (ID) of the cluster backup to restore. Use this value to restore the cluster from a backup
     *         instead of creating a new cluster. To find the backup ID, use <a>DescribeBackups</a>.
     */
    public String sourceBackupId() {
        return sourceBackupId;
    }

    /**
     * Returns true if the TagList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTagList() {
        return tagList != null && !(tagList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the TagList property for this object.
     */
    public List<Tag> tagList() {
        return tagList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(hsmType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBackupId());
        hashCode = 31 * hashCode + Objects.hashCode(tagList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        return Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(hsmType(), other.hsmType())
                && Objects.equals(sourceBackupId(), other.sourceBackupId()) && Objects.equals(tagList(), other.tagList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateClusterRequest").add("SubnetIds", subnetIds()).add("HsmType", hsmType())
                .add("SourceBackupId", sourceBackupId()).add("TagList", tagList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "HsmType":
            return Optional.ofNullable(clazz.cast(hsmType()));
        case "SourceBackupId":
            return Optional.ofNullable(clazz.cast(sourceBackupId()));
        case "TagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         * <p>
         * The identifiers (IDs) of the subnets where you are creating the cluster. You must specify at least one
         * subnet. If you specify multiple subnets, they must meet the following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * All subnets must be in the same virtual private cloud (VPC).
         * </p>
         * </li>
         * <li>
         * <p>
         * You can specify only one subnet per Availability Zone.
         * </p>
         * </li>
         * </ul>
         * 
         * @param subnetIds
         *        The identifiers (IDs) of the subnets where you are creating the cluster. You must specify at least one
         *        subnet. If you specify multiple subnets, they must meet the following criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        All subnets must be in the same virtual private cloud (VPC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can specify only one subnet per Availability Zone.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The identifiers (IDs) of the subnets where you are creating the cluster. You must specify at least one
         * subnet. If you specify multiple subnets, they must meet the following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * All subnets must be in the same virtual private cloud (VPC).
         * </p>
         * </li>
         * <li>
         * <p>
         * You can specify only one subnet per Availability Zone.
         * </p>
         * </li>
         * </ul>
         * 
         * @param subnetIds
         *        The identifiers (IDs) of the subnets where you are creating the cluster. You must specify at least one
         *        subnet. If you specify multiple subnets, they must meet the following criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        All subnets must be in the same virtual private cloud (VPC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can specify only one subnet per Availability Zone.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The type of HSM to use in the cluster. Currently the only allowed value is <code>hsm1.medium</code>.
         * </p>
         * 
         * @param hsmType
         *        The type of HSM to use in the cluster. Currently the only allowed value is <code>hsm1.medium</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmType(String hsmType);

        /**
         * <p>
         * The identifier (ID) of the cluster backup to restore. Use this value to restore the cluster from a backup
         * instead of creating a new cluster. To find the backup ID, use <a>DescribeBackups</a>.
         * </p>
         * 
         * @param sourceBackupId
         *        The identifier (ID) of the cluster backup to restore. Use this value to restore the cluster from a
         *        backup instead of creating a new cluster. To find the backup ID, use <a>DescribeBackups</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBackupId(String sourceBackupId);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<Tag> tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Tag... tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tagList(List<Tag>)}.
         * 
         * @param tagList
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagList(List<Tag>)
         */
        Builder tagList(Consumer<Tag.Builder>... tagList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmV2Request.BuilderImpl implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String hsmType;

        private String sourceBackupId;

        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            subnetIds(model.subnetIds);
            hsmType(model.hsmType);
            sourceBackupId(model.sourceBackupId);
            tagList(model.tagList);
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        public final String getHsmType() {
            return hsmType;
        }

        @Override
        public final Builder hsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        public final void setHsmType(String hsmType) {
            this.hsmType = hsmType;
        }

        public final String getSourceBackupId() {
            return sourceBackupId;
        }

        @Override
        public final Builder sourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
            return this;
        }

        public final void setSourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
        }

        public final Collection<Tag.Builder> getTagList() {
            return tagList != null ? tagList.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder>... tagList) {
            tagList(Stream.of(tagList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
