/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHSMV2Response;
import software.amazon.awssdk.services.cloudhsmv2.model.Cluster;
import software.amazon.awssdk.services.cloudhsmv2.model.ClustersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClustersResponse
extends CloudHSMV2Response
implements ToCopyableBuilder<Builder, DescribeClustersResponse> {
    private final List<Cluster> clusters;
    private final String nextToken;

    private DescribeClustersResponse(BuilderImpl builder) {
        super(builder);
        this.clusters = builder.clusters;
        this.nextToken = builder.nextToken;
    }

    public List<Cluster> clusters() {
        return this.clusters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersResponse)) {
            return false;
        }
        DescribeClustersResponse other = (DescribeClustersResponse)((Object)obj);
        return Objects.equals(this.clusters(), other.clusters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeClustersResponse").add("Clusters", this.clusters()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Clusters": {
                return Optional.of(clazz.cast(this.clusters()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMV2Response.BuilderImpl
    implements Builder {
        private List<Cluster> clusters;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClustersResponse model) {
            this.clusters(model.clusters);
            this.nextToken(model.nextToken);
        }

        public final Collection<Cluster.Builder> getClusters() {
            return this.clusters != null ? (Collection)this.clusters.stream().map(Cluster::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusters(Collection<Cluster> clusters) {
            this.clusters = ClustersCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Cluster ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        public final void setClusters(Collection<Cluster.BuilderImpl> clusters) {
            this.clusters = ClustersCopier.copyFromBuilder(clusters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeClustersResponse build() {
            return new DescribeClustersResponse(this);
        }
    }

    public static interface Builder
    extends CloudHSMV2Response.Builder,
    CopyableBuilder<Builder, DescribeClustersResponse> {
        public Builder clusters(Collection<Cluster> var1);

        public Builder clusters(Cluster ... var1);

        public Builder nextToken(String var1);
    }
}

