/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.model.TagResourceRequest;

@SdkInternalApi
public class TagResourceRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").build();
    private static final MarshallingInfo<List> TAGLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagList").build();
    private static final TagResourceRequestModelMarshaller INSTANCE = new TagResourceRequestModelMarshaller();

    public static TagResourceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TagResourceRequest tagResourceRequest, ProtocolMarshaller protocolMarshaller) {
        if (tagResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tagResourceRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(tagResourceRequest.tagList(), TAGLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

