/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudhsmv2.CloudHSMV2Client;
import software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.ListTagsResponse;

public final class ListTagsPaginator
implements SdkIterable<ListTagsResponse> {
    private final CloudHSMV2Client client;
    private final ListTagsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListTagsPaginator(CloudHSMV2Client client, ListTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTagsResponseFetcher();
    }

    public Iterator<ListTagsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListTagsResponseFetcher
    implements NextPageFetcher<ListTagsResponse> {
        private ListTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListTagsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTagsResponse nextPage(ListTagsResponse previousPage) {
            if (previousPage == null) {
                return ListTagsPaginator.this.client.listTags(ListTagsPaginator.this.firstRequest);
            }
            return ListTagsPaginator.this.client.listTags((ListTagsRequest)((Object)ListTagsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

