/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudhsmv2.CloudHSMV2Client;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsResponse;

public final class DescribeBackupsPaginator
implements SdkIterable<DescribeBackupsResponse> {
    private final CloudHSMV2Client client;
    private final DescribeBackupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeBackupsPaginator(CloudHSMV2Client client, DescribeBackupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeBackupsResponseFetcher();
    }

    public Iterator<DescribeBackupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class DescribeBackupsResponseFetcher
    implements NextPageFetcher<DescribeBackupsResponse> {
        private DescribeBackupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBackupsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeBackupsResponse nextPage(DescribeBackupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBackupsPaginator.this.client.describeBackups(DescribeBackupsPaginator.this.firstRequest);
            }
            return DescribeBackupsPaginator.this.client.describeBackups((DescribeBackupsRequest)((Object)DescribeBackupsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

