/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHSMV2Request;
import software.amazon.awssdk.services.cloudhsmv2.model.Tag;
import software.amazon.awssdk.services.cloudhsmv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TagResourceRequest
extends CloudHSMV2Request
implements ToCopyableBuilder<Builder, TagResourceRequest> {
    private final String resourceId;
    private final List<Tag> tagList;

    private TagResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.tagList = builder.tagList;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public List<Tag> tagList() {
        return this.tagList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagResourceRequest)) {
            return false;
        }
        TagResourceRequest other = (TagResourceRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.tagList(), other.tagList());
    }

    public String toString() {
        return ToString.builder((String)"TagResourceRequest").add("ResourceId", (Object)this.resourceId()).add("TagList", this.tagList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "TagList": {
                return Optional.of(clazz.cast(this.tagList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMV2Request.BuilderImpl
    implements Builder {
        private String resourceId;
        private List<Tag> tagList;

        private BuilderImpl() {
        }

        private BuilderImpl(TagResourceRequest model) {
            this.resourceId(model.resourceId);
            this.tagList(model.tagList);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<Tag.Builder> getTagList() {
            return this.tagList != null ? (Collection)this.tagList.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public TagResourceRequest build() {
            return new TagResourceRequest(this);
        }
    }

    public static interface Builder
    extends CloudHSMV2Request.Builder,
    CopyableBuilder<Builder, TagResourceRequest> {
        public Builder resourceId(String var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

