/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHSMV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateHsmRequest
extends CloudHSMV2Request
implements ToCopyableBuilder<Builder, CreateHsmRequest> {
    private final String clusterId;
    private final String availabilityZone;
    private final String ipAddress;

    private CreateHsmRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.availabilityZone = builder.availabilityZone;
        this.ipAddress = builder.ipAddress;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHsmRequest)) {
            return false;
        }
        CreateHsmRequest other = (CreateHsmRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.ipAddress(), other.ipAddress());
    }

    public String toString() {
        return ToString.builder((String)"CreateHsmRequest").add("ClusterId", (Object)this.clusterId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("IpAddress", (Object)this.ipAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "IpAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMV2Request.BuilderImpl
    implements Builder {
        private String clusterId;
        private String availabilityZone;
        private String ipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHsmRequest model) {
            this.clusterId(model.clusterId);
            this.availabilityZone(model.availabilityZone);
            this.ipAddress(model.ipAddress);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateHsmRequest build() {
            return new CreateHsmRequest(this);
        }
    }

    public static interface Builder
    extends CloudHSMV2Request.Builder,
    CopyableBuilder<Builder, CreateHsmRequest> {
        public Builder clusterId(String var1);

        public Builder availabilityZone(String var1);

        public Builder ipAddress(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

