/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeleteHsmRequestModelMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<String> HSMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HsmId").isBinary(false).build();
    private static final MarshallingInfo<String> ENIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EniId").isBinary(false).build();
    private static final MarshallingInfo<String> ENIIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EniIp").isBinary(false).build();
    private static final DeleteHsmRequestModelMarshaller INSTANCE = new DeleteHsmRequestModelMarshaller();

    private DeleteHsmRequestModelMarshaller() {
    }

    public static DeleteHsmRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeleteHsmRequest deleteHsmRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)deleteHsmRequest), (String)"deleteHsmRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deleteHsmRequest.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)deleteHsmRequest.hsmId(), HSMID_BINDING);
            protocolMarshaller.marshall((Object)deleteHsmRequest.eniId(), ENIID_BINDING);
            protocolMarshaller.marshall((Object)deleteHsmRequest.eniIp(), ENIIP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

