/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.model.Backup;

public class BackupUnmarshaller
implements Unmarshaller<Backup, JsonUnmarshallerContext> {
    private static final BackupUnmarshaller INSTANCE = new BackupUnmarshaller();

    public Backup unmarshall(JsonUnmarshallerContext context) throws Exception {
        Backup.Builder backupBuilder = Backup.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BackupId", targetDepth)) {
                    context.nextToken();
                    backupBuilder.backupId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BackupState", targetDepth)) {
                    context.nextToken();
                    backupBuilder.backupState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ClusterId", targetDepth)) {
                    context.nextToken();
                    backupBuilder.clusterId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreateTimestamp", targetDepth)) {
                    context.nextToken();
                    backupBuilder.createTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("CopyTimestamp", targetDepth)) {
                    context.nextToken();
                    backupBuilder.copyTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("SourceRegion", targetDepth)) {
                    context.nextToken();
                    backupBuilder.sourceRegion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SourceBackup", targetDepth)) {
                    context.nextToken();
                    backupBuilder.sourceBackup((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SourceCluster", targetDepth)) {
                    context.nextToken();
                    backupBuilder.sourceCluster((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Backup)backupBuilder.build();
    }

    public static BackupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

