/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2Client;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse;

public class DescribeClustersIterable
implements SdkIterable<DescribeClustersResponse> {
    private final CloudHsmV2Client client;
    private final DescribeClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClustersIterable(CloudHsmV2Client client, DescribeClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClustersResponseFetcher();
    }

    public Iterator<DescribeClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeClustersIterable resume(DescribeClustersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClustersIterable(this.client, (DescribeClustersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeClustersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeClustersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeClustersResponseFetcher
    implements SyncPageFetcher<DescribeClustersResponse> {
        private DescribeClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClustersResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public DescribeClustersResponse nextPage(DescribeClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeClustersIterable.this.client.describeClusters(DescribeClustersIterable.this.firstRequest);
            }
            return DescribeClustersIterable.this.client.describeClusters((DescribeClustersRequest)((Object)DescribeClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

