/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.cloudhsmv2.CloudHSMV2AsyncClient;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse;

public class DescribeClustersPublisher
implements SdkPublisher<DescribeClustersResponse> {
    private final CloudHSMV2AsyncClient client;
    private final DescribeClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClustersPublisher(CloudHSMV2AsyncClient client, DescribeClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClustersPublisher(CloudHSMV2AsyncClient client, DescribeClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final DescribeClustersPublisher resume(DescribeClustersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClustersPublisher(this.client, (DescribeClustersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeClustersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeClustersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeClustersResponseFetcher
    implements AsyncPageFetcher<DescribeClustersResponse> {
        private DescribeClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClustersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeClustersResponse> nextPage(DescribeClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeClustersPublisher.this.client.describeClusters(DescribeClustersPublisher.this.firstRequest);
            }
            return DescribeClustersPublisher.this.client.describeClusters((DescribeClustersRequest)((Object)DescribeClustersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

