/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHSMV2Response;
import software.amazon.awssdk.services.cloudhsmv2.model.ClusterState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InitializeClusterResponse
extends CloudHSMV2Response
implements ToCopyableBuilder<Builder, InitializeClusterResponse> {
    private final String state;
    private final String stateMessage;

    private InitializeClusterResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
    }

    public ClusterState state() {
        return ClusterState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String stateMessage() {
        return this.stateMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitializeClusterResponse)) {
            return false;
        }
        InitializeClusterResponse other = (InitializeClusterResponse)((Object)obj);
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateMessage(), other.stateMessage());
    }

    public String toString() {
        return ToString.builder((String)"InitializeClusterResponse").add("State", (Object)this.stateAsString()).add("StateMessage", (Object)this.stateMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "StateMessage": {
                return Optional.of(clazz.cast(this.stateMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMV2Response.BuilderImpl
    implements Builder {
        private String state;
        private String stateMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(InitializeClusterResponse model) {
            super(model);
            this.state(model.state);
            this.stateMessage(model.stateMessage);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public InitializeClusterResponse build() {
            return new InitializeClusterResponse(this);
        }
    }

    public static interface Builder
    extends CloudHSMV2Response.Builder,
    CopyableBuilder<Builder, InitializeClusterResponse> {
        public Builder state(String var1);

        public Builder state(ClusterState var1);

        public Builder stateMessage(String var1);
    }
}

