/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.HsmListCopier;
import software.amazon.awssdk.services.cloudhsm.model.PartitionSerialListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHapgResponse
extends CloudHsmResponse
implements ToCopyableBuilder<Builder, DescribeHapgResponse> {
    private static final SdkField<String> HAPG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HapgArn").getter(DescribeHapgResponse.getter(DescribeHapgResponse::hapgArn)).setter(DescribeHapgResponse.setter(Builder::hapgArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HapgArn").build()}).build();
    private static final SdkField<String> HAPG_SERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HapgSerial").getter(DescribeHapgResponse.getter(DescribeHapgResponse::hapgSerial)).setter(DescribeHapgResponse.setter(Builder::hapgSerial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HapgSerial").build()}).build();
    private static final SdkField<List<String>> HSMS_LAST_ACTION_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HsmsLastActionFailed").getter(DescribeHapgResponse.getter(DescribeHapgResponse::hsmsLastActionFailed)).setter(DescribeHapgResponse.setter(Builder::hsmsLastActionFailed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmsLastActionFailed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> HSMS_PENDING_DELETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HsmsPendingDeletion").getter(DescribeHapgResponse.getter(DescribeHapgResponse::hsmsPendingDeletion)).setter(DescribeHapgResponse.setter(Builder::hsmsPendingDeletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmsPendingDeletion").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> HSMS_PENDING_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HsmsPendingRegistration").getter(DescribeHapgResponse.getter(DescribeHapgResponse::hsmsPendingRegistration)).setter(DescribeHapgResponse.setter(Builder::hsmsPendingRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmsPendingRegistration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(DescribeHapgResponse.getter(DescribeHapgResponse::label)).setter(DescribeHapgResponse.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedTimestamp").getter(DescribeHapgResponse.getter(DescribeHapgResponse::lastModifiedTimestamp)).setter(DescribeHapgResponse.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimestamp").build()}).build();
    private static final SdkField<List<String>> PARTITION_SERIAL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionSerialList").getter(DescribeHapgResponse.getter(DescribeHapgResponse::partitionSerialList)).setter(DescribeHapgResponse.setter(Builder::partitionSerialList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionSerialList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeHapgResponse.getter(DescribeHapgResponse::stateAsString)).setter(DescribeHapgResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HAPG_ARN_FIELD, HAPG_SERIAL_FIELD, HSMS_LAST_ACTION_FAILED_FIELD, HSMS_PENDING_DELETION_FIELD, HSMS_PENDING_REGISTRATION_FIELD, LABEL_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, PARTITION_SERIAL_LIST_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeHapgResponse.memberNameToFieldInitializer();
    private final String hapgArn;
    private final String hapgSerial;
    private final List<String> hsmsLastActionFailed;
    private final List<String> hsmsPendingDeletion;
    private final List<String> hsmsPendingRegistration;
    private final String label;
    private final String lastModifiedTimestamp;
    private final List<String> partitionSerialList;
    private final String state;

    private DescribeHapgResponse(BuilderImpl builder) {
        super(builder);
        this.hapgArn = builder.hapgArn;
        this.hapgSerial = builder.hapgSerial;
        this.hsmsLastActionFailed = builder.hsmsLastActionFailed;
        this.hsmsPendingDeletion = builder.hsmsPendingDeletion;
        this.hsmsPendingRegistration = builder.hsmsPendingRegistration;
        this.label = builder.label;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.partitionSerialList = builder.partitionSerialList;
        this.state = builder.state;
    }

    public final String hapgArn() {
        return this.hapgArn;
    }

    public final String hapgSerial() {
        return this.hapgSerial;
    }

    public final boolean hasHsmsLastActionFailed() {
        return this.hsmsLastActionFailed != null && !(this.hsmsLastActionFailed instanceof SdkAutoConstructList);
    }

    public final List<String> hsmsLastActionFailed() {
        return this.hsmsLastActionFailed;
    }

    public final boolean hasHsmsPendingDeletion() {
        return this.hsmsPendingDeletion != null && !(this.hsmsPendingDeletion instanceof SdkAutoConstructList);
    }

    public final List<String> hsmsPendingDeletion() {
        return this.hsmsPendingDeletion;
    }

    public final boolean hasHsmsPendingRegistration() {
        return this.hsmsPendingRegistration != null && !(this.hsmsPendingRegistration instanceof SdkAutoConstructList);
    }

    public final List<String> hsmsPendingRegistration() {
        return this.hsmsPendingRegistration;
    }

    public final String label() {
        return this.label;
    }

    public final String lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final boolean hasPartitionSerialList() {
        return this.partitionSerialList != null && !(this.partitionSerialList instanceof SdkAutoConstructList);
    }

    public final List<String> partitionSerialList() {
        return this.partitionSerialList;
    }

    public final CloudHsmObjectState state() {
        return CloudHsmObjectState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hapgArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hapgSerial());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHsmsLastActionFailed() ? this.hsmsLastActionFailed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHsmsPendingDeletion() ? this.hsmsPendingDeletion() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHsmsPendingRegistration() ? this.hsmsPendingRegistration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionSerialList() ? this.partitionSerialList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHapgResponse)) {
            return false;
        }
        DescribeHapgResponse other = (DescribeHapgResponse)((Object)obj);
        return Objects.equals(this.hapgArn(), other.hapgArn()) && Objects.equals(this.hapgSerial(), other.hapgSerial()) && this.hasHsmsLastActionFailed() == other.hasHsmsLastActionFailed() && Objects.equals(this.hsmsLastActionFailed(), other.hsmsLastActionFailed()) && this.hasHsmsPendingDeletion() == other.hasHsmsPendingDeletion() && Objects.equals(this.hsmsPendingDeletion(), other.hsmsPendingDeletion()) && this.hasHsmsPendingRegistration() == other.hasHsmsPendingRegistration() && Objects.equals(this.hsmsPendingRegistration(), other.hsmsPendingRegistration()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && this.hasPartitionSerialList() == other.hasPartitionSerialList() && Objects.equals(this.partitionSerialList(), other.partitionSerialList()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHapgResponse").add("HapgArn", (Object)this.hapgArn()).add("HapgSerial", (Object)this.hapgSerial()).add("HsmsLastActionFailed", this.hasHsmsLastActionFailed() ? this.hsmsLastActionFailed() : null).add("HsmsPendingDeletion", this.hasHsmsPendingDeletion() ? this.hsmsPendingDeletion() : null).add("HsmsPendingRegistration", this.hasHsmsPendingRegistration() ? this.hsmsPendingRegistration() : null).add("Label", (Object)this.label()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("PartitionSerialList", this.hasPartitionSerialList() ? this.partitionSerialList() : null).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HapgArn": {
                return Optional.ofNullable(clazz.cast(this.hapgArn()));
            }
            case "HapgSerial": {
                return Optional.ofNullable(clazz.cast(this.hapgSerial()));
            }
            case "HsmsLastActionFailed": {
                return Optional.ofNullable(clazz.cast(this.hsmsLastActionFailed()));
            }
            case "HsmsPendingDeletion": {
                return Optional.ofNullable(clazz.cast(this.hsmsPendingDeletion()));
            }
            case "HsmsPendingRegistration": {
                return Optional.ofNullable(clazz.cast(this.hsmsPendingRegistration()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "LastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "PartitionSerialList": {
                return Optional.ofNullable(clazz.cast(this.partitionSerialList()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HapgArn", HAPG_ARN_FIELD);
        map.put("HapgSerial", HAPG_SERIAL_FIELD);
        map.put("HsmsLastActionFailed", HSMS_LAST_ACTION_FAILED_FIELD);
        map.put("HsmsPendingDeletion", HSMS_PENDING_DELETION_FIELD);
        map.put("HsmsPendingRegistration", HSMS_PENDING_REGISTRATION_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("LastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("PartitionSerialList", PARTITION_SERIAL_LIST_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHapgResponse, T> g) {
        return obj -> g.apply((DescribeHapgResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmResponse.BuilderImpl
    implements Builder {
        private String hapgArn;
        private String hapgSerial;
        private List<String> hsmsLastActionFailed = DefaultSdkAutoConstructList.getInstance();
        private List<String> hsmsPendingDeletion = DefaultSdkAutoConstructList.getInstance();
        private List<String> hsmsPendingRegistration = DefaultSdkAutoConstructList.getInstance();
        private String label;
        private String lastModifiedTimestamp;
        private List<String> partitionSerialList = DefaultSdkAutoConstructList.getInstance();
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHapgResponse model) {
            super(model);
            this.hapgArn(model.hapgArn);
            this.hapgSerial(model.hapgSerial);
            this.hsmsLastActionFailed(model.hsmsLastActionFailed);
            this.hsmsPendingDeletion(model.hsmsPendingDeletion);
            this.hsmsPendingRegistration(model.hsmsPendingRegistration);
            this.label(model.label);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.partitionSerialList(model.partitionSerialList);
            this.state(model.state);
        }

        public final String getHapgArn() {
            return this.hapgArn;
        }

        public final void setHapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
        }

        @Override
        public final Builder hapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
            return this;
        }

        public final String getHapgSerial() {
            return this.hapgSerial;
        }

        public final void setHapgSerial(String hapgSerial) {
            this.hapgSerial = hapgSerial;
        }

        @Override
        public final Builder hapgSerial(String hapgSerial) {
            this.hapgSerial = hapgSerial;
            return this;
        }

        public final Collection<String> getHsmsLastActionFailed() {
            if (this.hsmsLastActionFailed instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hsmsLastActionFailed;
        }

        public final void setHsmsLastActionFailed(Collection<String> hsmsLastActionFailed) {
            this.hsmsLastActionFailed = HsmListCopier.copy(hsmsLastActionFailed);
        }

        @Override
        public final Builder hsmsLastActionFailed(Collection<String> hsmsLastActionFailed) {
            this.hsmsLastActionFailed = HsmListCopier.copy(hsmsLastActionFailed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmsLastActionFailed(String ... hsmsLastActionFailed) {
            this.hsmsLastActionFailed(Arrays.asList(hsmsLastActionFailed));
            return this;
        }

        public final Collection<String> getHsmsPendingDeletion() {
            if (this.hsmsPendingDeletion instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hsmsPendingDeletion;
        }

        public final void setHsmsPendingDeletion(Collection<String> hsmsPendingDeletion) {
            this.hsmsPendingDeletion = HsmListCopier.copy(hsmsPendingDeletion);
        }

        @Override
        public final Builder hsmsPendingDeletion(Collection<String> hsmsPendingDeletion) {
            this.hsmsPendingDeletion = HsmListCopier.copy(hsmsPendingDeletion);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmsPendingDeletion(String ... hsmsPendingDeletion) {
            this.hsmsPendingDeletion(Arrays.asList(hsmsPendingDeletion));
            return this;
        }

        public final Collection<String> getHsmsPendingRegistration() {
            if (this.hsmsPendingRegistration instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hsmsPendingRegistration;
        }

        public final void setHsmsPendingRegistration(Collection<String> hsmsPendingRegistration) {
            this.hsmsPendingRegistration = HsmListCopier.copy(hsmsPendingRegistration);
        }

        @Override
        public final Builder hsmsPendingRegistration(Collection<String> hsmsPendingRegistration) {
            this.hsmsPendingRegistration = HsmListCopier.copy(hsmsPendingRegistration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmsPendingRegistration(String ... hsmsPendingRegistration) {
            this.hsmsPendingRegistration(Arrays.asList(hsmsPendingRegistration));
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(String lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(String lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final Collection<String> getPartitionSerialList() {
            if (this.partitionSerialList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionSerialList;
        }

        public final void setPartitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
        }

        @Override
        public final Builder partitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionSerialList(String ... partitionSerialList) {
            this.partitionSerialList(Arrays.asList(partitionSerialList));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CloudHsmObjectState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public DescribeHapgResponse build() {
            return new DescribeHapgResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudHsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHapgResponse> {
        public Builder hapgArn(String var1);

        public Builder hapgSerial(String var1);

        public Builder hsmsLastActionFailed(Collection<String> var1);

        public Builder hsmsLastActionFailed(String ... var1);

        public Builder hsmsPendingDeletion(Collection<String> var1);

        public Builder hsmsPendingDeletion(String ... var1);

        public Builder hsmsPendingRegistration(Collection<String> var1);

        public Builder hsmsPendingRegistration(String ... var1);

        public Builder label(String var1);

        public Builder lastModifiedTimestamp(String var1);

        public Builder partitionSerialList(Collection<String> var1);

        public Builder partitionSerialList(String ... var1);

        public Builder state(String var1);

        public Builder state(CloudHsmObjectState var1);
    }
}

