/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHsmRequest
extends CloudHsmRequest
implements ToCopyableBuilder<Builder, DescribeHsmRequest> {
    private static final SdkField<String> HSM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmArn").getter(DescribeHsmRequest.getter(DescribeHsmRequest::hsmArn)).setter(DescribeHsmRequest.setter(Builder::hsmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmArn").build()}).build();
    private static final SdkField<String> HSM_SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmSerialNumber").getter(DescribeHsmRequest.getter(DescribeHsmRequest::hsmSerialNumber)).setter(DescribeHsmRequest.setter(Builder::hsmSerialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmSerialNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_ARN_FIELD, HSM_SERIAL_NUMBER_FIELD));
    private final String hsmArn;
    private final String hsmSerialNumber;

    private DescribeHsmRequest(BuilderImpl builder) {
        super(builder);
        this.hsmArn = builder.hsmArn;
        this.hsmSerialNumber = builder.hsmSerialNumber;
    }

    public String hsmArn() {
        return this.hsmArn;
    }

    public String hsmSerialNumber() {
        return this.hsmSerialNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmSerialNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmRequest)) {
            return false;
        }
        DescribeHsmRequest other = (DescribeHsmRequest)((Object)obj);
        return Objects.equals(this.hsmArn(), other.hsmArn()) && Objects.equals(this.hsmSerialNumber(), other.hsmSerialNumber());
    }

    public String toString() {
        return ToString.builder((String)"DescribeHsmRequest").add("HsmArn", (Object)this.hsmArn()).add("HsmSerialNumber", (Object)this.hsmSerialNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmArn": {
                return Optional.ofNullable(clazz.cast(this.hsmArn()));
            }
            case "HsmSerialNumber": {
                return Optional.ofNullable(clazz.cast(this.hsmSerialNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHsmRequest, T> g) {
        return obj -> g.apply((DescribeHsmRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmRequest.BuilderImpl
    implements Builder {
        private String hsmArn;
        private String hsmSerialNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmRequest model) {
            super(model);
            this.hsmArn(model.hsmArn);
            this.hsmSerialNumber(model.hsmSerialNumber);
        }

        public final String getHsmArn() {
            return this.hsmArn;
        }

        @Override
        public final Builder hsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
            return this;
        }

        public final void setHsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
        }

        public final String getHsmSerialNumber() {
            return this.hsmSerialNumber;
        }

        @Override
        public final Builder hsmSerialNumber(String hsmSerialNumber) {
            this.hsmSerialNumber = hsmSerialNumber;
            return this;
        }

        public final void setHsmSerialNumber(String hsmSerialNumber) {
            this.hsmSerialNumber = hsmSerialNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeHsmRequest build() {
            return new DescribeHsmRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHsmRequest> {
        public Builder hsmArn(String var1);

        public Builder hsmSerialNumber(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

