/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of the <a>CreateHAPartitionGroup</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHapgResponse extends CloudHsmResponse implements
        ToCopyableBuilder<CreateHapgResponse.Builder, CreateHapgResponse> {
    private static final SdkField<String> HAPG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateHapgResponse::hapgArn)).setter(setter(Builder::hapgArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HapgArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HAPG_ARN_FIELD));

    private final String hapgArn;

    private CreateHapgResponse(BuilderImpl builder) {
        super(builder);
        this.hapgArn = builder.hapgArn;
    }

    /**
     * <p>
     * The ARN of the high-availability partition group.
     * </p>
     * 
     * @return The ARN of the high-availability partition group.
     */
    public String hapgArn() {
        return hapgArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hapgArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHapgResponse)) {
            return false;
        }
        CreateHapgResponse other = (CreateHapgResponse) obj;
        return Objects.equals(hapgArn(), other.hapgArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateHapgResponse").add("HapgArn", hapgArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HapgArn":
            return Optional.ofNullable(clazz.cast(hapgArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHapgResponse, T> g) {
        return obj -> g.apply((CreateHapgResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateHapgResponse> {
        /**
         * <p>
         * The ARN of the high-availability partition group.
         * </p>
         * 
         * @param hapgArn
         *        The ARN of the high-availability partition group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hapgArn(String hapgArn);
    }

    static final class BuilderImpl extends CloudHsmResponse.BuilderImpl implements Builder {
        private String hapgArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHapgResponse model) {
            super(model);
            hapgArn(model.hapgArn);
        }

        public final String getHapgArn() {
            return hapgArn;
        }

        @Override
        public final Builder hapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
            return this;
        }

        public final void setHapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
        }

        @Override
        public CreateHapgResponse build() {
            return new CreateHapgResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
