/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudhsm.model.CloudHSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyHsmRequest
extends CloudHSMRequest
implements ToCopyableBuilder<Builder, ModifyHsmRequest> {
    private final String hsmArn;
    private final String subnetId;
    private final String eniIp;
    private final String iamRoleArn;
    private final String externalId;
    private final String syslogIp;

    private ModifyHsmRequest(BuilderImpl builder) {
        super(builder);
        this.hsmArn = builder.hsmArn;
        this.subnetId = builder.subnetId;
        this.eniIp = builder.eniIp;
        this.iamRoleArn = builder.iamRoleArn;
        this.externalId = builder.externalId;
        this.syslogIp = builder.syslogIp;
    }

    public String hsmArn() {
        return this.hsmArn;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String eniIp() {
        return this.eniIp;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public String externalId() {
        return this.externalId;
    }

    public String syslogIp() {
        return this.syslogIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.syslogIp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHsmRequest)) {
            return false;
        }
        ModifyHsmRequest other = (ModifyHsmRequest)((Object)obj);
        return Objects.equals(this.hsmArn(), other.hsmArn()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.eniIp(), other.eniIp()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.syslogIp(), other.syslogIp());
    }

    public String toString() {
        return ToString.builder((String)"ModifyHsmRequest").add("HsmArn", (Object)this.hsmArn()).add("SubnetId", (Object)this.subnetId()).add("EniIp", (Object)this.eniIp()).add("IamRoleArn", (Object)this.iamRoleArn()).add("ExternalId", (Object)this.externalId()).add("SyslogIp", (Object)this.syslogIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmArn": {
                return Optional.of(clazz.cast(this.hsmArn()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "EniIp": {
                return Optional.of(clazz.cast(this.eniIp()));
            }
            case "IamRoleArn": {
                return Optional.of(clazz.cast(this.iamRoleArn()));
            }
            case "ExternalId": {
                return Optional.of(clazz.cast(this.externalId()));
            }
            case "SyslogIp": {
                return Optional.of(clazz.cast(this.syslogIp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMRequest.BuilderImpl
    implements Builder {
        private String hsmArn;
        private String subnetId;
        private String eniIp;
        private String iamRoleArn;
        private String externalId;
        private String syslogIp;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHsmRequest model) {
            this.hsmArn(model.hsmArn);
            this.subnetId(model.subnetId);
            this.eniIp(model.eniIp);
            this.iamRoleArn(model.iamRoleArn);
            this.externalId(model.externalId);
            this.syslogIp(model.syslogIp);
        }

        public final String getHsmArn() {
            return this.hsmArn;
        }

        @Override
        public final Builder hsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
            return this;
        }

        public final void setHsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getEniIp() {
            return this.eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getSyslogIp() {
            return this.syslogIp;
        }

        @Override
        public final Builder syslogIp(String syslogIp) {
            this.syslogIp = syslogIp;
            return this;
        }

        public final void setSyslogIp(String syslogIp) {
            this.syslogIp = syslogIp;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyHsmRequest build() {
            return new ModifyHsmRequest(this);
        }
    }

    public static interface Builder
    extends CloudHSMRequest.Builder,
    CopyableBuilder<Builder, ModifyHsmRequest> {
        public Builder hsmArn(String var1);

        public Builder subnetId(String var1);

        public Builder eniIp(String var1);

        public Builder iamRoleArn(String var1);

        public Builder externalId(String var1);

        public Builder syslogIp(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

