/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudhsm.CloudHSMClient;
import software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.cloudhsm.model.CloudHSMException;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmInternalException;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmServiceException;
import software.amazon.awssdk.services.cloudhsm.model.CreateHapgRequest;
import software.amazon.awssdk.services.cloudhsm.model.CreateHapgResponse;
import software.amazon.awssdk.services.cloudhsm.model.CreateHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.CreateHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientRequest;
import software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientResponse;
import software.amazon.awssdk.services.cloudhsm.model.DeleteHapgRequest;
import software.amazon.awssdk.services.cloudhsm.model.DeleteHapgResponse;
import software.amazon.awssdk.services.cloudhsm.model.DeleteHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.DeleteHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.DeleteLunaClientRequest;
import software.amazon.awssdk.services.cloudhsm.model.DeleteLunaClientResponse;
import software.amazon.awssdk.services.cloudhsm.model.DescribeHapgRequest;
import software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse;
import software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientRequest;
import software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientResponse;
import software.amazon.awssdk.services.cloudhsm.model.GetConfigRequest;
import software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse;
import software.amazon.awssdk.services.cloudhsm.model.InvalidRequestException;
import software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse;
import software.amazon.awssdk.services.cloudhsm.model.ListHapgsRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListHapgsResponse;
import software.amazon.awssdk.services.cloudhsm.model.ListHsmsRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListHsmsResponse;
import software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsResponse;
import software.amazon.awssdk.services.cloudhsm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHapgRequest;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHapgResponse;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientRequest;
import software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientResponse;
import software.amazon.awssdk.services.cloudhsm.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.cloudhsm.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.cloudhsm.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.AddTagsToResourceResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.CreateHapgRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.CreateHapgResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.CreateHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.CreateHsmResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.CreateLunaClientRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.CreateLunaClientResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DeleteHapgRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DeleteHapgResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DeleteHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DeleteHsmResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DeleteLunaClientRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DeleteLunaClientResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DescribeHapgRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DescribeHapgResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DescribeHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DescribeHsmResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DescribeLunaClientRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DescribeLunaClientResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.GetConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.GetConfigResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListAvailableZonesRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListAvailableZonesResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListHapgsRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListHapgsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListHsmsRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListHsmsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListLunaClientsRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListLunaClientsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListTagsForResourceResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ModifyHapgRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ModifyHapgResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ModifyHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ModifyHsmResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ModifyLunaClientRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ModifyLunaClientResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.RemoveTagsFromResourceResponseUnmarshaller;

@SdkInternalApi
final class DefaultCloudHSMClient
implements CloudHSMClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultCloudHSMClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "cloudhsm";
    }

    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsToResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToResourceRequest).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateHapgResponse createHapg(CreateHapgRequest createHapgRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHapgResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateHapgResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHapgRequest).withMarshaller((Marshaller)new CreateHapgRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateHsmResponse createHsm(CreateHsmRequest createHsmRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHsmResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateHsmResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHsmRequest).withMarshaller((Marshaller)new CreateHsmRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateLunaClientResponse createLunaClient(CreateLunaClientRequest createLunaClientRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLunaClientResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateLunaClientResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLunaClientRequest).withMarshaller((Marshaller)new CreateLunaClientRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteHapgResponse deleteHapg(DeleteHapgRequest deleteHapgRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteHapgResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteHapgResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteHapgRequest).withMarshaller((Marshaller)new DeleteHapgRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteHsmResponse deleteHsm(DeleteHsmRequest deleteHsmRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteHsmResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteHsmResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteHsmRequest).withMarshaller((Marshaller)new DeleteHsmRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteLunaClientResponse deleteLunaClient(DeleteLunaClientRequest deleteLunaClientRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLunaClientResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteLunaClientResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLunaClientRequest).withMarshaller((Marshaller)new DeleteLunaClientRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeHapgResponse describeHapg(DescribeHapgRequest describeHapgRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeHapgResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeHapgResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHapgRequest).withMarshaller((Marshaller)new DescribeHapgRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeHsmResponse describeHsm(DescribeHsmRequest describeHsmRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeHsmResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeHsmResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHsmRequest).withMarshaller((Marshaller)new DescribeHsmRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeLunaClientResponse describeLunaClient(DescribeLunaClientRequest describeLunaClientRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLunaClientResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeLunaClientResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLunaClientRequest).withMarshaller((Marshaller)new DescribeLunaClientRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetConfigResponse getConfig(GetConfigRequest getConfigRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetConfigResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConfigRequest).withMarshaller((Marshaller)new GetConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListAvailableZonesResponse listAvailableZones(ListAvailableZonesRequest listAvailableZonesRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAvailableZonesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListAvailableZonesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAvailableZonesRequest).withMarshaller((Marshaller)new ListAvailableZonesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListHapgsResponse listHapgs(ListHapgsRequest listHapgsRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHapgsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListHapgsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHapgsRequest).withMarshaller((Marshaller)new ListHapgsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListHsmsResponse listHsms(ListHsmsRequest listHsmsRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHsmsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListHsmsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHsmsRequest).withMarshaller((Marshaller)new ListHsmsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListLunaClientsResponse listLunaClients(ListLunaClientsRequest listLunaClientsRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLunaClientsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListLunaClientsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLunaClientsRequest).withMarshaller((Marshaller)new ListLunaClientsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyHapgResponse modifyHapg(ModifyHapgRequest modifyHapgRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ModifyHapgResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ModifyHapgResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyHapgRequest).withMarshaller((Marshaller)new ModifyHapgRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyHsmResponse modifyHsm(ModifyHsmRequest modifyHsmRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ModifyHsmResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ModifyHsmResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyHsmRequest).withMarshaller((Marshaller)new ModifyHsmRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyLunaClientResponse modifyLunaClient(ModifyLunaClientRequest modifyLunaClientRequest) throws CloudHsmServiceException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ModifyLunaClientResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ModifyLunaClientResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyLunaClientRequest).withMarshaller((Marshaller)new ModifyLunaClientRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, SdkServiceException, SdkClientException, CloudHSMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveTagsFromResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RemoveTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromResourceRequest).withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(CloudHSMException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmInternalException").withModeledClass(CloudHsmInternalException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmServiceException").withModeledClass(CloudHsmServiceException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

