/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudhsm.model.ClientVersion;
import software.amazon.awssdk.services.cloudhsm.model.CloudHSMRequest;
import software.amazon.awssdk.services.cloudhsm.model.HapgListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetConfigRequest
extends CloudHSMRequest
implements ToCopyableBuilder<Builder, GetConfigRequest> {
    private final String clientArn;
    private final String clientVersion;
    private final List<String> hapgList;

    private GetConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clientArn = builder.clientArn;
        this.clientVersion = builder.clientVersion;
        this.hapgList = builder.hapgList;
    }

    public String clientArn() {
        return this.clientArn;
    }

    public ClientVersion clientVersion() {
        return ClientVersion.fromValue(this.clientVersion);
    }

    public String clientVersionString() {
        return this.clientVersion;
    }

    public List<String> hapgList() {
        return this.hapgList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVersionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hapgList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigRequest)) {
            return false;
        }
        GetConfigRequest other = (GetConfigRequest)((Object)obj);
        return Objects.equals(this.clientArn(), other.clientArn()) && Objects.equals(this.clientVersionString(), other.clientVersionString()) && Objects.equals(this.hapgList(), other.hapgList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clientArn() != null) {
            sb.append("ClientArn: ").append(this.clientArn()).append(",");
        }
        if (this.clientVersionString() != null) {
            sb.append("ClientVersion: ").append(this.clientVersionString()).append(",");
        }
        if (this.hapgList() != null) {
            sb.append("HapgList: ").append(this.hapgList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientArn": {
                return Optional.of(clazz.cast(this.clientArn()));
            }
            case "ClientVersion": {
                return Optional.of(clazz.cast(this.clientVersionString()));
            }
            case "HapgList": {
                return Optional.of(clazz.cast(this.hapgList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMRequest.BuilderImpl
    implements Builder {
        private String clientArn;
        private String clientVersion;
        private List<String> hapgList;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigRequest model) {
            this.clientArn(model.clientArn);
            this.clientVersion(model.clientVersion);
            this.hapgList(model.hapgList);
        }

        public final String getClientArn() {
            return this.clientArn;
        }

        @Override
        public final Builder clientArn(String clientArn) {
            this.clientArn = clientArn;
            return this;
        }

        public final void setClientArn(String clientArn) {
            this.clientArn = clientArn;
        }

        public final String getClientVersion() {
            return this.clientVersion;
        }

        @Override
        public final Builder clientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        @Override
        public final Builder clientVersion(ClientVersion clientVersion) {
            this.clientVersion(clientVersion.toString());
            return this;
        }

        public final void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        public final Collection<String> getHapgList() {
            return this.hapgList;
        }

        @Override
        public final Builder hapgList(Collection<String> hapgList) {
            this.hapgList = HapgListCopier.copy(hapgList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hapgList(String ... hapgList) {
            this.hapgList(Arrays.asList(hapgList));
            return this;
        }

        public final void setHapgList(Collection<String> hapgList) {
            this.hapgList = HapgListCopier.copy(hapgList);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetConfigRequest build() {
            return new GetConfigRequest(this);
        }
    }

    public static interface Builder
    extends CloudHSMRequest.Builder,
    CopyableBuilder<Builder, GetConfigRequest> {
        public Builder clientArn(String var1);

        public Builder clientVersion(String var1);

        public Builder clientVersion(ClientVersion var1);

        public Builder hapgList(Collection<String> var1);

        public Builder hapgList(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

