/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudhsm.model.CloudHSMResponse;
import software.amazon.awssdk.services.cloudhsm.model.HsmStatus;
import software.amazon.awssdk.services.cloudhsm.model.PartitionListCopier;
import software.amazon.awssdk.services.cloudhsm.model.SubscriptionType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHsmResponse
extends CloudHSMResponse
implements ToCopyableBuilder<Builder, DescribeHsmResponse> {
    private final String hsmArn;
    private final String status;
    private final String statusDetails;
    private final String availabilityZone;
    private final String eniId;
    private final String eniIp;
    private final String subscriptionType;
    private final String subscriptionStartDate;
    private final String subscriptionEndDate;
    private final String vpcId;
    private final String subnetId;
    private final String iamRoleArn;
    private final String serialNumber;
    private final String vendorName;
    private final String hsmType;
    private final String softwareVersion;
    private final String sshPublicKey;
    private final String sshKeyLastUpdated;
    private final String serverCertUri;
    private final String serverCertLastUpdated;
    private final List<String> partitions;

    private DescribeHsmResponse(BuilderImpl builder) {
        super(builder);
        this.hsmArn = builder.hsmArn;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.availabilityZone = builder.availabilityZone;
        this.eniId = builder.eniId;
        this.eniIp = builder.eniIp;
        this.subscriptionType = builder.subscriptionType;
        this.subscriptionStartDate = builder.subscriptionStartDate;
        this.subscriptionEndDate = builder.subscriptionEndDate;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.iamRoleArn = builder.iamRoleArn;
        this.serialNumber = builder.serialNumber;
        this.vendorName = builder.vendorName;
        this.hsmType = builder.hsmType;
        this.softwareVersion = builder.softwareVersion;
        this.sshPublicKey = builder.sshPublicKey;
        this.sshKeyLastUpdated = builder.sshKeyLastUpdated;
        this.serverCertUri = builder.serverCertUri;
        this.serverCertLastUpdated = builder.serverCertLastUpdated;
        this.partitions = builder.partitions;
    }

    public String hsmArn() {
        return this.hsmArn;
    }

    public HsmStatus status() {
        return HsmStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String eniId() {
        return this.eniId;
    }

    public String eniIp() {
        return this.eniIp;
    }

    public SubscriptionType subscriptionType() {
        return SubscriptionType.fromValue(this.subscriptionType);
    }

    public String subscriptionTypeString() {
        return this.subscriptionType;
    }

    public String subscriptionStartDate() {
        return this.subscriptionStartDate;
    }

    public String subscriptionEndDate() {
        return this.subscriptionEndDate;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public String vendorName() {
        return this.vendorName;
    }

    public String hsmType() {
        return this.hsmType;
    }

    public String softwareVersion() {
        return this.softwareVersion;
    }

    public String sshPublicKey() {
        return this.sshPublicKey;
    }

    public String sshKeyLastUpdated() {
        return this.sshKeyLastUpdated;
    }

    public String serverCertUri() {
        return this.serverCertUri;
    }

    public String serverCertLastUpdated() {
        return this.serverCertLastUpdated;
    }

    public List<String> partitions() {
        return this.partitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmType());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshKeyLastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertLastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmResponse)) {
            return false;
        }
        DescribeHsmResponse other = (DescribeHsmResponse)((Object)obj);
        return Objects.equals(this.hsmArn(), other.hsmArn()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.eniId(), other.eniId()) && Objects.equals(this.eniIp(), other.eniIp()) && Objects.equals(this.subscriptionTypeString(), other.subscriptionTypeString()) && Objects.equals(this.subscriptionStartDate(), other.subscriptionStartDate()) && Objects.equals(this.subscriptionEndDate(), other.subscriptionEndDate()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.vendorName(), other.vendorName()) && Objects.equals(this.hsmType(), other.hsmType()) && Objects.equals(this.softwareVersion(), other.softwareVersion()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey()) && Objects.equals(this.sshKeyLastUpdated(), other.sshKeyLastUpdated()) && Objects.equals(this.serverCertUri(), other.serverCertUri()) && Objects.equals(this.serverCertLastUpdated(), other.serverCertLastUpdated()) && Objects.equals(this.partitions(), other.partitions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hsmArn() != null) {
            sb.append("HsmArn: ").append(this.hsmArn()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.eniId() != null) {
            sb.append("EniId: ").append(this.eniId()).append(",");
        }
        if (this.eniIp() != null) {
            sb.append("EniIp: ").append(this.eniIp()).append(",");
        }
        if (this.subscriptionTypeString() != null) {
            sb.append("SubscriptionType: ").append(this.subscriptionTypeString()).append(",");
        }
        if (this.subscriptionStartDate() != null) {
            sb.append("SubscriptionStartDate: ").append(this.subscriptionStartDate()).append(",");
        }
        if (this.subscriptionEndDate() != null) {
            sb.append("SubscriptionEndDate: ").append(this.subscriptionEndDate()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.iamRoleArn() != null) {
            sb.append("IamRoleArn: ").append(this.iamRoleArn()).append(",");
        }
        if (this.serialNumber() != null) {
            sb.append("SerialNumber: ").append(this.serialNumber()).append(",");
        }
        if (this.vendorName() != null) {
            sb.append("VendorName: ").append(this.vendorName()).append(",");
        }
        if (this.hsmType() != null) {
            sb.append("HsmType: ").append(this.hsmType()).append(",");
        }
        if (this.softwareVersion() != null) {
            sb.append("SoftwareVersion: ").append(this.softwareVersion()).append(",");
        }
        if (this.sshPublicKey() != null) {
            sb.append("SshPublicKey: ").append(this.sshPublicKey()).append(",");
        }
        if (this.sshKeyLastUpdated() != null) {
            sb.append("SshKeyLastUpdated: ").append(this.sshKeyLastUpdated()).append(",");
        }
        if (this.serverCertUri() != null) {
            sb.append("ServerCertUri: ").append(this.serverCertUri()).append(",");
        }
        if (this.serverCertLastUpdated() != null) {
            sb.append("ServerCertLastUpdated: ").append(this.serverCertLastUpdated()).append(",");
        }
        if (this.partitions() != null) {
            sb.append("Partitions: ").append(this.partitions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmArn": {
                return Optional.of(clazz.cast(this.hsmArn()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusDetails": {
                return Optional.of(clazz.cast(this.statusDetails()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "EniId": {
                return Optional.of(clazz.cast(this.eniId()));
            }
            case "EniIp": {
                return Optional.of(clazz.cast(this.eniIp()));
            }
            case "SubscriptionType": {
                return Optional.of(clazz.cast(this.subscriptionTypeString()));
            }
            case "SubscriptionStartDate": {
                return Optional.of(clazz.cast(this.subscriptionStartDate()));
            }
            case "SubscriptionEndDate": {
                return Optional.of(clazz.cast(this.subscriptionEndDate()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "IamRoleArn": {
                return Optional.of(clazz.cast(this.iamRoleArn()));
            }
            case "SerialNumber": {
                return Optional.of(clazz.cast(this.serialNumber()));
            }
            case "VendorName": {
                return Optional.of(clazz.cast(this.vendorName()));
            }
            case "HsmType": {
                return Optional.of(clazz.cast(this.hsmType()));
            }
            case "SoftwareVersion": {
                return Optional.of(clazz.cast(this.softwareVersion()));
            }
            case "SshPublicKey": {
                return Optional.of(clazz.cast(this.sshPublicKey()));
            }
            case "SshKeyLastUpdated": {
                return Optional.of(clazz.cast(this.sshKeyLastUpdated()));
            }
            case "ServerCertUri": {
                return Optional.of(clazz.cast(this.serverCertUri()));
            }
            case "ServerCertLastUpdated": {
                return Optional.of(clazz.cast(this.serverCertLastUpdated()));
            }
            case "Partitions": {
                return Optional.of(clazz.cast(this.partitions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMResponse.BuilderImpl
    implements Builder {
        private String hsmArn;
        private String status;
        private String statusDetails;
        private String availabilityZone;
        private String eniId;
        private String eniIp;
        private String subscriptionType;
        private String subscriptionStartDate;
        private String subscriptionEndDate;
        private String vpcId;
        private String subnetId;
        private String iamRoleArn;
        private String serialNumber;
        private String vendorName;
        private String hsmType;
        private String softwareVersion;
        private String sshPublicKey;
        private String sshKeyLastUpdated;
        private String serverCertUri;
        private String serverCertLastUpdated;
        private List<String> partitions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmResponse model) {
            this.hsmArn(model.hsmArn);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.availabilityZone(model.availabilityZone);
            this.eniId(model.eniId);
            this.eniIp(model.eniIp);
            this.subscriptionType(model.subscriptionType);
            this.subscriptionStartDate(model.subscriptionStartDate);
            this.subscriptionEndDate(model.subscriptionEndDate);
            this.vpcId(model.vpcId);
            this.subnetId(model.subnetId);
            this.iamRoleArn(model.iamRoleArn);
            this.serialNumber(model.serialNumber);
            this.vendorName(model.vendorName);
            this.hsmType(model.hsmType);
            this.softwareVersion(model.softwareVersion);
            this.sshPublicKey(model.sshPublicKey);
            this.sshKeyLastUpdated(model.sshKeyLastUpdated);
            this.serverCertUri(model.serverCertUri);
            this.serverCertLastUpdated(model.serverCertLastUpdated);
            this.partitions(model.partitions);
        }

        public final String getHsmArn() {
            return this.hsmArn;
        }

        @Override
        public final Builder hsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
            return this;
        }

        public final void setHsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HsmStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getEniId() {
            return this.eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        public final String getEniIp() {
            return this.eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        public final String getSubscriptionType() {
            return this.subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType.toString());
            return this;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public final String getSubscriptionStartDate() {
            return this.subscriptionStartDate;
        }

        @Override
        public final Builder subscriptionStartDate(String subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
            return this;
        }

        public final void setSubscriptionStartDate(String subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
        }

        public final String getSubscriptionEndDate() {
            return this.subscriptionEndDate;
        }

        @Override
        public final Builder subscriptionEndDate(String subscriptionEndDate) {
            this.subscriptionEndDate = subscriptionEndDate;
            return this;
        }

        public final void setSubscriptionEndDate(String subscriptionEndDate) {
            this.subscriptionEndDate = subscriptionEndDate;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final String getVendorName() {
            return this.vendorName;
        }

        @Override
        public final Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public final void setVendorName(String vendorName) {
            this.vendorName = vendorName;
        }

        public final String getHsmType() {
            return this.hsmType;
        }

        @Override
        public final Builder hsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        public final void setHsmType(String hsmType) {
            this.hsmType = hsmType;
        }

        public final String getSoftwareVersion() {
            return this.softwareVersion;
        }

        @Override
        public final Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public final void setSoftwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final String getSshKeyLastUpdated() {
            return this.sshKeyLastUpdated;
        }

        @Override
        public final Builder sshKeyLastUpdated(String sshKeyLastUpdated) {
            this.sshKeyLastUpdated = sshKeyLastUpdated;
            return this;
        }

        public final void setSshKeyLastUpdated(String sshKeyLastUpdated) {
            this.sshKeyLastUpdated = sshKeyLastUpdated;
        }

        public final String getServerCertUri() {
            return this.serverCertUri;
        }

        @Override
        public final Builder serverCertUri(String serverCertUri) {
            this.serverCertUri = serverCertUri;
            return this;
        }

        public final void setServerCertUri(String serverCertUri) {
            this.serverCertUri = serverCertUri;
        }

        public final String getServerCertLastUpdated() {
            return this.serverCertLastUpdated;
        }

        @Override
        public final Builder serverCertLastUpdated(String serverCertLastUpdated) {
            this.serverCertLastUpdated = serverCertLastUpdated;
            return this;
        }

        public final void setServerCertLastUpdated(String serverCertLastUpdated) {
            this.serverCertLastUpdated = serverCertLastUpdated;
        }

        public final Collection<String> getPartitions() {
            return this.partitions;
        }

        @Override
        public final Builder partitions(Collection<String> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(String ... partitions) {
            this.partitions(Arrays.asList(partitions));
            return this;
        }

        public final void setPartitions(Collection<String> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
        }

        @Override
        public DescribeHsmResponse build() {
            return new DescribeHsmResponse(this);
        }
    }

    public static interface Builder
    extends CloudHSMResponse.Builder,
    CopyableBuilder<Builder, DescribeHsmResponse> {
        public Builder hsmArn(String var1);

        public Builder status(String var1);

        public Builder status(HsmStatus var1);

        public Builder statusDetails(String var1);

        public Builder availabilityZone(String var1);

        public Builder eniId(String var1);

        public Builder eniIp(String var1);

        public Builder subscriptionType(String var1);

        public Builder subscriptionType(SubscriptionType var1);

        public Builder subscriptionStartDate(String var1);

        public Builder subscriptionEndDate(String var1);

        public Builder vpcId(String var1);

        public Builder subnetId(String var1);

        public Builder iamRoleArn(String var1);

        public Builder serialNumber(String var1);

        public Builder vendorName(String var1);

        public Builder hsmType(String var1);

        public Builder softwareVersion(String var1);

        public Builder sshPublicKey(String var1);

        public Builder sshKeyLastUpdated(String var1);

        public Builder serverCertUri(String var1);

        public Builder serverCertLastUpdated(String var1);

        public Builder partitions(Collection<String> var1);

        public Builder partitions(String ... var1);
    }
}

