/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cloudhsm.model.ClientListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListLunaClientsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListLunaClientsResponse> {
    private final List<String> clientList;
    private final String nextToken;

    private ListLunaClientsResponse(BuilderImpl builder) {
        this.clientList = builder.clientList;
        this.nextToken = builder.nextToken;
    }

    public List<String> clientList() {
        return this.clientList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLunaClientsResponse)) {
            return false;
        }
        ListLunaClientsResponse other = (ListLunaClientsResponse)((Object)obj);
        return Objects.equals(this.clientList(), other.clientList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clientList() != null) {
            sb.append("ClientList: ").append(this.clientList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientList": {
                return Optional.of(clazz.cast(this.clientList()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> clientList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLunaClientsResponse model) {
            this.clientList(model.clientList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getClientList() {
            return this.clientList;
        }

        @Override
        public final Builder clientList(Collection<String> clientList) {
            this.clientList = ClientListCopier.copy(clientList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientList(String ... clientList) {
            this.clientList(Arrays.asList(clientList));
            return this;
        }

        public final void setClientList(Collection<String> clientList) {
            this.clientList = ClientListCopier.copy(clientList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListLunaClientsResponse build() {
            return new ListLunaClientsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListLunaClientsResponse> {
        public Builder clientList(Collection<String> var1);

        public Builder clientList(String ... var1);

        public Builder nextToken(String var1);
    }
}

