/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHsmRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeHsmRequest> {
    private final String hsmArn;
    private final String hsmSerialNumber;

    private DescribeHsmRequest(BuilderImpl builder) {
        this.hsmArn = builder.hsmArn;
        this.hsmSerialNumber = builder.hsmSerialNumber;
    }

    public String hsmArn() {
        return this.hsmArn;
    }

    public String hsmSerialNumber() {
        return this.hsmSerialNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmSerialNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmRequest)) {
            return false;
        }
        DescribeHsmRequest other = (DescribeHsmRequest)((Object)obj);
        return Objects.equals(this.hsmArn(), other.hsmArn()) && Objects.equals(this.hsmSerialNumber(), other.hsmSerialNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hsmArn() != null) {
            sb.append("HsmArn: ").append(this.hsmArn()).append(",");
        }
        if (this.hsmSerialNumber() != null) {
            sb.append("HsmSerialNumber: ").append(this.hsmSerialNumber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmArn": {
                return Optional.of(clazz.cast(this.hsmArn()));
            }
            case "HsmSerialNumber": {
                return Optional.of(clazz.cast(this.hsmSerialNumber()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String hsmArn;
        private String hsmSerialNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmRequest model) {
            this.hsmArn(model.hsmArn);
            this.hsmSerialNumber(model.hsmSerialNumber);
        }

        public final String getHsmArn() {
            return this.hsmArn;
        }

        @Override
        public final Builder hsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
            return this;
        }

        public final void setHsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
        }

        public final String getHsmSerialNumber() {
            return this.hsmSerialNumber;
        }

        @Override
        public final Builder hsmSerialNumber(String hsmSerialNumber) {
            this.hsmSerialNumber = hsmSerialNumber;
            return this;
        }

        public final void setHsmSerialNumber(String hsmSerialNumber) {
            this.hsmSerialNumber = hsmSerialNumber;
        }

        public DescribeHsmRequest build() {
            return new DescribeHsmRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHsmRequest> {
        public Builder hsmArn(String var1);

        public Builder hsmSerialNumber(String var1);
    }
}

