/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLunaClientRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeLunaClientRequest> {
    private final String clientArn;
    private final String certificateFingerprint;

    private DescribeLunaClientRequest(BuilderImpl builder) {
        this.clientArn = builder.clientArn;
        this.certificateFingerprint = builder.certificateFingerprint;
    }

    public String clientArn() {
        return this.clientArn;
    }

    public String certificateFingerprint() {
        return this.certificateFingerprint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientArn() == null ? 0 : this.clientArn().hashCode());
        hashCode = 31 * hashCode + (this.certificateFingerprint() == null ? 0 : this.certificateFingerprint().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLunaClientRequest)) {
            return false;
        }
        DescribeLunaClientRequest other = (DescribeLunaClientRequest)((Object)obj);
        if (other.clientArn() == null ^ this.clientArn() == null) {
            return false;
        }
        if (other.clientArn() != null && !other.clientArn().equals(this.clientArn())) {
            return false;
        }
        if (other.certificateFingerprint() == null ^ this.certificateFingerprint() == null) {
            return false;
        }
        return other.certificateFingerprint() == null || other.certificateFingerprint().equals(this.certificateFingerprint());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clientArn() != null) {
            sb.append("ClientArn: ").append(this.clientArn()).append(",");
        }
        if (this.certificateFingerprint() != null) {
            sb.append("CertificateFingerprint: ").append(this.certificateFingerprint()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientArn": {
                return Optional.of(clazz.cast(this.clientArn()));
            }
            case "CertificateFingerprint": {
                return Optional.of(clazz.cast(this.certificateFingerprint()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clientArn;
        private String certificateFingerprint;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLunaClientRequest model) {
            this.clientArn(model.clientArn);
            this.certificateFingerprint(model.certificateFingerprint);
        }

        public final String getClientArn() {
            return this.clientArn;
        }

        @Override
        public final Builder clientArn(String clientArn) {
            this.clientArn = clientArn;
            return this;
        }

        public final void setClientArn(String clientArn) {
            this.clientArn = clientArn;
        }

        public final String getCertificateFingerprint() {
            return this.certificateFingerprint;
        }

        @Override
        public final Builder certificateFingerprint(String certificateFingerprint) {
            this.certificateFingerprint = certificateFingerprint;
            return this;
        }

        public final void setCertificateFingerprint(String certificateFingerprint) {
            this.certificateFingerprint = certificateFingerprint;
        }

        public DescribeLunaClientRequest build() {
            return new DescribeLunaClientRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLunaClientRequest> {
        public Builder clientArn(String var1);

        public Builder certificateFingerprint(String var1);
    }
}

