/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState;
import software.amazon.awssdk.services.cloudhsm.model.HsmListCopier;
import software.amazon.awssdk.services.cloudhsm.model.PartitionSerialListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHapgResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeHapgResponse> {
    private final String hapgArn;
    private final String hapgSerial;
    private final List<String> hsmsLastActionFailed;
    private final List<String> hsmsPendingDeletion;
    private final List<String> hsmsPendingRegistration;
    private final String label;
    private final String lastModifiedTimestamp;
    private final List<String> partitionSerialList;
    private final String state;

    private DescribeHapgResponse(BuilderImpl builder) {
        this.hapgArn = builder.hapgArn;
        this.hapgSerial = builder.hapgSerial;
        this.hsmsLastActionFailed = builder.hsmsLastActionFailed;
        this.hsmsPendingDeletion = builder.hsmsPendingDeletion;
        this.hsmsPendingRegistration = builder.hsmsPendingRegistration;
        this.label = builder.label;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.partitionSerialList = builder.partitionSerialList;
        this.state = builder.state;
    }

    public String hapgArn() {
        return this.hapgArn;
    }

    public String hapgSerial() {
        return this.hapgSerial;
    }

    public List<String> hsmsLastActionFailed() {
        return this.hsmsLastActionFailed;
    }

    public List<String> hsmsPendingDeletion() {
        return this.hsmsPendingDeletion;
    }

    public List<String> hsmsPendingRegistration() {
        return this.hsmsPendingRegistration;
    }

    public String label() {
        return this.label;
    }

    public String lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public List<String> partitionSerialList() {
        return this.partitionSerialList;
    }

    public CloudHsmObjectState state() {
        return CloudHsmObjectState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hapgArn() == null ? 0 : this.hapgArn().hashCode());
        hashCode = 31 * hashCode + (this.hapgSerial() == null ? 0 : this.hapgSerial().hashCode());
        hashCode = 31 * hashCode + (this.hsmsLastActionFailed() == null ? 0 : this.hsmsLastActionFailed().hashCode());
        hashCode = 31 * hashCode + (this.hsmsPendingDeletion() == null ? 0 : this.hsmsPendingDeletion().hashCode());
        hashCode = 31 * hashCode + (this.hsmsPendingRegistration() == null ? 0 : this.hsmsPendingRegistration().hashCode());
        hashCode = 31 * hashCode + (this.label() == null ? 0 : this.label().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedTimestamp() == null ? 0 : this.lastModifiedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.partitionSerialList() == null ? 0 : this.partitionSerialList().hashCode());
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHapgResponse)) {
            return false;
        }
        DescribeHapgResponse other = (DescribeHapgResponse)((Object)obj);
        if (other.hapgArn() == null ^ this.hapgArn() == null) {
            return false;
        }
        if (other.hapgArn() != null && !other.hapgArn().equals(this.hapgArn())) {
            return false;
        }
        if (other.hapgSerial() == null ^ this.hapgSerial() == null) {
            return false;
        }
        if (other.hapgSerial() != null && !other.hapgSerial().equals(this.hapgSerial())) {
            return false;
        }
        if (other.hsmsLastActionFailed() == null ^ this.hsmsLastActionFailed() == null) {
            return false;
        }
        if (other.hsmsLastActionFailed() != null && !other.hsmsLastActionFailed().equals(this.hsmsLastActionFailed())) {
            return false;
        }
        if (other.hsmsPendingDeletion() == null ^ this.hsmsPendingDeletion() == null) {
            return false;
        }
        if (other.hsmsPendingDeletion() != null && !other.hsmsPendingDeletion().equals(this.hsmsPendingDeletion())) {
            return false;
        }
        if (other.hsmsPendingRegistration() == null ^ this.hsmsPendingRegistration() == null) {
            return false;
        }
        if (other.hsmsPendingRegistration() != null && !other.hsmsPendingRegistration().equals(this.hsmsPendingRegistration())) {
            return false;
        }
        if (other.label() == null ^ this.label() == null) {
            return false;
        }
        if (other.label() != null && !other.label().equals(this.label())) {
            return false;
        }
        if (other.lastModifiedTimestamp() == null ^ this.lastModifiedTimestamp() == null) {
            return false;
        }
        if (other.lastModifiedTimestamp() != null && !other.lastModifiedTimestamp().equals(this.lastModifiedTimestamp())) {
            return false;
        }
        if (other.partitionSerialList() == null ^ this.partitionSerialList() == null) {
            return false;
        }
        if (other.partitionSerialList() != null && !other.partitionSerialList().equals(this.partitionSerialList())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        return other.stateString() == null || other.stateString().equals(this.stateString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hapgArn() != null) {
            sb.append("HapgArn: ").append(this.hapgArn()).append(",");
        }
        if (this.hapgSerial() != null) {
            sb.append("HapgSerial: ").append(this.hapgSerial()).append(",");
        }
        if (this.hsmsLastActionFailed() != null) {
            sb.append("HsmsLastActionFailed: ").append(this.hsmsLastActionFailed()).append(",");
        }
        if (this.hsmsPendingDeletion() != null) {
            sb.append("HsmsPendingDeletion: ").append(this.hsmsPendingDeletion()).append(",");
        }
        if (this.hsmsPendingRegistration() != null) {
            sb.append("HsmsPendingRegistration: ").append(this.hsmsPendingRegistration()).append(",");
        }
        if (this.label() != null) {
            sb.append("Label: ").append(this.label()).append(",");
        }
        if (this.lastModifiedTimestamp() != null) {
            sb.append("LastModifiedTimestamp: ").append(this.lastModifiedTimestamp()).append(",");
        }
        if (this.partitionSerialList() != null) {
            sb.append("PartitionSerialList: ").append(this.partitionSerialList()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HapgArn": {
                return Optional.of(clazz.cast(this.hapgArn()));
            }
            case "HapgSerial": {
                return Optional.of(clazz.cast(this.hapgSerial()));
            }
            case "HsmsLastActionFailed": {
                return Optional.of(clazz.cast(this.hsmsLastActionFailed()));
            }
            case "HsmsPendingDeletion": {
                return Optional.of(clazz.cast(this.hsmsPendingDeletion()));
            }
            case "HsmsPendingRegistration": {
                return Optional.of(clazz.cast(this.hsmsPendingRegistration()));
            }
            case "Label": {
                return Optional.of(clazz.cast(this.label()));
            }
            case "LastModifiedTimestamp": {
                return Optional.of(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "PartitionSerialList": {
                return Optional.of(clazz.cast(this.partitionSerialList()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String hapgArn;
        private String hapgSerial;
        private List<String> hsmsLastActionFailed;
        private List<String> hsmsPendingDeletion;
        private List<String> hsmsPendingRegistration;
        private String label;
        private String lastModifiedTimestamp;
        private List<String> partitionSerialList;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHapgResponse model) {
            this.hapgArn(model.hapgArn);
            this.hapgSerial(model.hapgSerial);
            this.hsmsLastActionFailed(model.hsmsLastActionFailed);
            this.hsmsPendingDeletion(model.hsmsPendingDeletion);
            this.hsmsPendingRegistration(model.hsmsPendingRegistration);
            this.label(model.label);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.partitionSerialList(model.partitionSerialList);
            this.state(model.state);
        }

        public final String getHapgArn() {
            return this.hapgArn;
        }

        @Override
        public final Builder hapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
            return this;
        }

        public final void setHapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
        }

        public final String getHapgSerial() {
            return this.hapgSerial;
        }

        @Override
        public final Builder hapgSerial(String hapgSerial) {
            this.hapgSerial = hapgSerial;
            return this;
        }

        public final void setHapgSerial(String hapgSerial) {
            this.hapgSerial = hapgSerial;
        }

        public final Collection<String> getHsmsLastActionFailed() {
            return this.hsmsLastActionFailed;
        }

        @Override
        public final Builder hsmsLastActionFailed(Collection<String> hsmsLastActionFailed) {
            this.hsmsLastActionFailed = HsmListCopier.copy(hsmsLastActionFailed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmsLastActionFailed(String ... hsmsLastActionFailed) {
            this.hsmsLastActionFailed(Arrays.asList(hsmsLastActionFailed));
            return this;
        }

        public final void setHsmsLastActionFailed(Collection<String> hsmsLastActionFailed) {
            this.hsmsLastActionFailed = HsmListCopier.copy(hsmsLastActionFailed);
        }

        public final Collection<String> getHsmsPendingDeletion() {
            return this.hsmsPendingDeletion;
        }

        @Override
        public final Builder hsmsPendingDeletion(Collection<String> hsmsPendingDeletion) {
            this.hsmsPendingDeletion = HsmListCopier.copy(hsmsPendingDeletion);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmsPendingDeletion(String ... hsmsPendingDeletion) {
            this.hsmsPendingDeletion(Arrays.asList(hsmsPendingDeletion));
            return this;
        }

        public final void setHsmsPendingDeletion(Collection<String> hsmsPendingDeletion) {
            this.hsmsPendingDeletion = HsmListCopier.copy(hsmsPendingDeletion);
        }

        public final Collection<String> getHsmsPendingRegistration() {
            return this.hsmsPendingRegistration;
        }

        @Override
        public final Builder hsmsPendingRegistration(Collection<String> hsmsPendingRegistration) {
            this.hsmsPendingRegistration = HsmListCopier.copy(hsmsPendingRegistration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmsPendingRegistration(String ... hsmsPendingRegistration) {
            this.hsmsPendingRegistration(Arrays.asList(hsmsPendingRegistration));
            return this;
        }

        public final void setHsmsPendingRegistration(Collection<String> hsmsPendingRegistration) {
            this.hsmsPendingRegistration = HsmListCopier.copy(hsmsPendingRegistration);
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final String getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(String lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final void setLastModifiedTimestamp(String lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        public final Collection<String> getPartitionSerialList() {
            return this.partitionSerialList;
        }

        @Override
        public final Builder partitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionSerialList(String ... partitionSerialList) {
            this.partitionSerialList(Arrays.asList(partitionSerialList));
            return this;
        }

        public final void setPartitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CloudHsmObjectState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public DescribeHapgResponse build() {
            return new DescribeHapgResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHapgResponse> {
        public Builder hapgArn(String var1);

        public Builder hapgSerial(String var1);

        public Builder hsmsLastActionFailed(Collection<String> var1);

        public Builder hsmsLastActionFailed(String ... var1);

        public Builder hsmsPendingDeletion(Collection<String> var1);

        public Builder hsmsPendingDeletion(String ... var1);

        public Builder hsmsPendingRegistration(Collection<String> var1);

        public Builder hsmsPendingRegistration(String ... var1);

        public Builder label(String var1);

        public Builder lastModifiedTimestamp(String var1);

        public Builder partitionSerialList(Collection<String> var1);

        public Builder partitionSerialList(String ... var1);

        public Builder state(String var1);

        public Builder state(CloudHsmObjectState var1);
    }
}

