/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.HapgListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHapgsResponse
extends CloudHsmResponse
implements ToCopyableBuilder<Builder, ListHapgsResponse> {
    private final List<String> hapgList;
    private final String nextToken;

    private ListHapgsResponse(BuilderImpl builder) {
        super(builder);
        this.hapgList = builder.hapgList;
        this.nextToken = builder.nextToken;
    }

    public List<String> hapgList() {
        return this.hapgList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hapgList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHapgsResponse)) {
            return false;
        }
        ListHapgsResponse other = (ListHapgsResponse)((Object)obj);
        return Objects.equals(this.hapgList(), other.hapgList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListHapgsResponse").add("HapgList", this.hapgList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HapgList": {
                return Optional.ofNullable(clazz.cast(this.hapgList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHsmResponse.BuilderImpl
    implements Builder {
        private List<String> hapgList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHapgsResponse model) {
            super(model);
            this.hapgList(model.hapgList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getHapgList() {
            return this.hapgList;
        }

        @Override
        public final Builder hapgList(Collection<String> hapgList) {
            this.hapgList = HapgListCopier.copy(hapgList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hapgList(String ... hapgList) {
            this.hapgList(Arrays.asList(hapgList));
            return this;
        }

        public final void setHapgList(Collection<String> hapgList) {
            this.hapgList = HapgListCopier.copy(hapgList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHapgsResponse build() {
            return new ListHapgsResponse(this);
        }
    }

    public static interface Builder
    extends CloudHsmResponse.Builder,
    CopyableBuilder<Builder, ListHapgsResponse> {
        public Builder hapgList(Collection<String> var1);

        public Builder hapgList(String ... var1);

        public Builder nextToken(String var1);
    }
}

