/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsm.model.GetConfigRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetConfigRequestModelMarshaller {
    private static final MarshallingInfo<String> CLIENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientArn").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientVersion").isBinary(false).build();
    private static final MarshallingInfo<List> HAPGLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HapgList").isBinary(false).build();
    private static final GetConfigRequestModelMarshaller INSTANCE = new GetConfigRequestModelMarshaller();

    private GetConfigRequestModelMarshaller() {
    }

    public static GetConfigRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetConfigRequest getConfigRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getConfigRequest), (String)"getConfigRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getConfigRequest.clientArn(), CLIENTARN_BINDING);
            protocolMarshaller.marshall((Object)getConfigRequest.clientVersionAsString(), CLIENTVERSION_BINDING);
            protocolMarshaller.marshall(getConfigRequest.hapgList(), HAPGLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

