/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AddTagsToResourceRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").isBinary(false).build();
    private static final MarshallingInfo<List> TAGLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagList").isBinary(false).build();
    private static final AddTagsToResourceRequestModelMarshaller INSTANCE = new AddTagsToResourceRequestModelMarshaller();

    private AddTagsToResourceRequestModelMarshaller() {
    }

    public static AddTagsToResourceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AddTagsToResourceRequest addTagsToResourceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)addTagsToResourceRequest), (String)"addTagsToResourceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)addTagsToResourceRequest.resourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall(addTagsToResourceRequest.tagList(), TAGLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

