/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudhsm.model.HsmStatus;
import software.amazon.awssdk.services.cloudhsm.model.PartitionListCopier;
import software.amazon.awssdk.services.cloudhsm.model.SubscriptionType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHsmResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeHsmResponse> {
    private final String hsmArn;
    private final String status;
    private final String statusDetails;
    private final String availabilityZone;
    private final String eniId;
    private final String eniIp;
    private final String subscriptionType;
    private final String subscriptionStartDate;
    private final String subscriptionEndDate;
    private final String vpcId;
    private final String subnetId;
    private final String iamRoleArn;
    private final String serialNumber;
    private final String vendorName;
    private final String hsmType;
    private final String softwareVersion;
    private final String sshPublicKey;
    private final String sshKeyLastUpdated;
    private final String serverCertUri;
    private final String serverCertLastUpdated;
    private final List<String> partitions;

    private DescribeHsmResponse(BuilderImpl builder) {
        this.hsmArn = builder.hsmArn;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.availabilityZone = builder.availabilityZone;
        this.eniId = builder.eniId;
        this.eniIp = builder.eniIp;
        this.subscriptionType = builder.subscriptionType;
        this.subscriptionStartDate = builder.subscriptionStartDate;
        this.subscriptionEndDate = builder.subscriptionEndDate;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.iamRoleArn = builder.iamRoleArn;
        this.serialNumber = builder.serialNumber;
        this.vendorName = builder.vendorName;
        this.hsmType = builder.hsmType;
        this.softwareVersion = builder.softwareVersion;
        this.sshPublicKey = builder.sshPublicKey;
        this.sshKeyLastUpdated = builder.sshKeyLastUpdated;
        this.serverCertUri = builder.serverCertUri;
        this.serverCertLastUpdated = builder.serverCertLastUpdated;
        this.partitions = builder.partitions;
    }

    public String hsmArn() {
        return this.hsmArn;
    }

    public String status() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String eniId() {
        return this.eniId;
    }

    public String eniIp() {
        return this.eniIp;
    }

    public String subscriptionType() {
        return this.subscriptionType;
    }

    public String subscriptionStartDate() {
        return this.subscriptionStartDate;
    }

    public String subscriptionEndDate() {
        return this.subscriptionEndDate;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public String vendorName() {
        return this.vendorName;
    }

    public String hsmType() {
        return this.hsmType;
    }

    public String softwareVersion() {
        return this.softwareVersion;
    }

    public String sshPublicKey() {
        return this.sshPublicKey;
    }

    public String sshKeyLastUpdated() {
        return this.sshKeyLastUpdated;
    }

    public String serverCertUri() {
        return this.serverCertUri;
    }

    public String serverCertLastUpdated() {
        return this.serverCertLastUpdated;
    }

    public List<String> partitions() {
        return this.partitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hsmArn() == null ? 0 : this.hsmArn().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusDetails() == null ? 0 : this.statusDetails().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.eniId() == null ? 0 : this.eniId().hashCode());
        hashCode = 31 * hashCode + (this.eniIp() == null ? 0 : this.eniIp().hashCode());
        hashCode = 31 * hashCode + (this.subscriptionType() == null ? 0 : this.subscriptionType().hashCode());
        hashCode = 31 * hashCode + (this.subscriptionStartDate() == null ? 0 : this.subscriptionStartDate().hashCode());
        hashCode = 31 * hashCode + (this.subscriptionEndDate() == null ? 0 : this.subscriptionEndDate().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.iamRoleArn() == null ? 0 : this.iamRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.serialNumber() == null ? 0 : this.serialNumber().hashCode());
        hashCode = 31 * hashCode + (this.vendorName() == null ? 0 : this.vendorName().hashCode());
        hashCode = 31 * hashCode + (this.hsmType() == null ? 0 : this.hsmType().hashCode());
        hashCode = 31 * hashCode + (this.softwareVersion() == null ? 0 : this.softwareVersion().hashCode());
        hashCode = 31 * hashCode + (this.sshPublicKey() == null ? 0 : this.sshPublicKey().hashCode());
        hashCode = 31 * hashCode + (this.sshKeyLastUpdated() == null ? 0 : this.sshKeyLastUpdated().hashCode());
        hashCode = 31 * hashCode + (this.serverCertUri() == null ? 0 : this.serverCertUri().hashCode());
        hashCode = 31 * hashCode + (this.serverCertLastUpdated() == null ? 0 : this.serverCertLastUpdated().hashCode());
        hashCode = 31 * hashCode + (this.partitions() == null ? 0 : this.partitions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmResponse)) {
            return false;
        }
        DescribeHsmResponse other = (DescribeHsmResponse)((Object)obj);
        if (other.hsmArn() == null ^ this.hsmArn() == null) {
            return false;
        }
        if (other.hsmArn() != null && !other.hsmArn().equals(this.hsmArn())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusDetails() == null ^ this.statusDetails() == null) {
            return false;
        }
        if (other.statusDetails() != null && !other.statusDetails().equals(this.statusDetails())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.eniId() == null ^ this.eniId() == null) {
            return false;
        }
        if (other.eniId() != null && !other.eniId().equals(this.eniId())) {
            return false;
        }
        if (other.eniIp() == null ^ this.eniIp() == null) {
            return false;
        }
        if (other.eniIp() != null && !other.eniIp().equals(this.eniIp())) {
            return false;
        }
        if (other.subscriptionType() == null ^ this.subscriptionType() == null) {
            return false;
        }
        if (other.subscriptionType() != null && !other.subscriptionType().equals(this.subscriptionType())) {
            return false;
        }
        if (other.subscriptionStartDate() == null ^ this.subscriptionStartDate() == null) {
            return false;
        }
        if (other.subscriptionStartDate() != null && !other.subscriptionStartDate().equals(this.subscriptionStartDate())) {
            return false;
        }
        if (other.subscriptionEndDate() == null ^ this.subscriptionEndDate() == null) {
            return false;
        }
        if (other.subscriptionEndDate() != null && !other.subscriptionEndDate().equals(this.subscriptionEndDate())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.iamRoleArn() == null ^ this.iamRoleArn() == null) {
            return false;
        }
        if (other.iamRoleArn() != null && !other.iamRoleArn().equals(this.iamRoleArn())) {
            return false;
        }
        if (other.serialNumber() == null ^ this.serialNumber() == null) {
            return false;
        }
        if (other.serialNumber() != null && !other.serialNumber().equals(this.serialNumber())) {
            return false;
        }
        if (other.vendorName() == null ^ this.vendorName() == null) {
            return false;
        }
        if (other.vendorName() != null && !other.vendorName().equals(this.vendorName())) {
            return false;
        }
        if (other.hsmType() == null ^ this.hsmType() == null) {
            return false;
        }
        if (other.hsmType() != null && !other.hsmType().equals(this.hsmType())) {
            return false;
        }
        if (other.softwareVersion() == null ^ this.softwareVersion() == null) {
            return false;
        }
        if (other.softwareVersion() != null && !other.softwareVersion().equals(this.softwareVersion())) {
            return false;
        }
        if (other.sshPublicKey() == null ^ this.sshPublicKey() == null) {
            return false;
        }
        if (other.sshPublicKey() != null && !other.sshPublicKey().equals(this.sshPublicKey())) {
            return false;
        }
        if (other.sshKeyLastUpdated() == null ^ this.sshKeyLastUpdated() == null) {
            return false;
        }
        if (other.sshKeyLastUpdated() != null && !other.sshKeyLastUpdated().equals(this.sshKeyLastUpdated())) {
            return false;
        }
        if (other.serverCertUri() == null ^ this.serverCertUri() == null) {
            return false;
        }
        if (other.serverCertUri() != null && !other.serverCertUri().equals(this.serverCertUri())) {
            return false;
        }
        if (other.serverCertLastUpdated() == null ^ this.serverCertLastUpdated() == null) {
            return false;
        }
        if (other.serverCertLastUpdated() != null && !other.serverCertLastUpdated().equals(this.serverCertLastUpdated())) {
            return false;
        }
        if (other.partitions() == null ^ this.partitions() == null) {
            return false;
        }
        return other.partitions() == null || other.partitions().equals(this.partitions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hsmArn() != null) {
            sb.append("HsmArn: ").append(this.hsmArn()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.eniId() != null) {
            sb.append("EniId: ").append(this.eniId()).append(",");
        }
        if (this.eniIp() != null) {
            sb.append("EniIp: ").append(this.eniIp()).append(",");
        }
        if (this.subscriptionType() != null) {
            sb.append("SubscriptionType: ").append(this.subscriptionType()).append(",");
        }
        if (this.subscriptionStartDate() != null) {
            sb.append("SubscriptionStartDate: ").append(this.subscriptionStartDate()).append(",");
        }
        if (this.subscriptionEndDate() != null) {
            sb.append("SubscriptionEndDate: ").append(this.subscriptionEndDate()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.iamRoleArn() != null) {
            sb.append("IamRoleArn: ").append(this.iamRoleArn()).append(",");
        }
        if (this.serialNumber() != null) {
            sb.append("SerialNumber: ").append(this.serialNumber()).append(",");
        }
        if (this.vendorName() != null) {
            sb.append("VendorName: ").append(this.vendorName()).append(",");
        }
        if (this.hsmType() != null) {
            sb.append("HsmType: ").append(this.hsmType()).append(",");
        }
        if (this.softwareVersion() != null) {
            sb.append("SoftwareVersion: ").append(this.softwareVersion()).append(",");
        }
        if (this.sshPublicKey() != null) {
            sb.append("SshPublicKey: ").append(this.sshPublicKey()).append(",");
        }
        if (this.sshKeyLastUpdated() != null) {
            sb.append("SshKeyLastUpdated: ").append(this.sshKeyLastUpdated()).append(",");
        }
        if (this.serverCertUri() != null) {
            sb.append("ServerCertUri: ").append(this.serverCertUri()).append(",");
        }
        if (this.serverCertLastUpdated() != null) {
            sb.append("ServerCertLastUpdated: ").append(this.serverCertLastUpdated()).append(",");
        }
        if (this.partitions() != null) {
            sb.append("Partitions: ").append(this.partitions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String hsmArn;
        private String status;
        private String statusDetails;
        private String availabilityZone;
        private String eniId;
        private String eniIp;
        private String subscriptionType;
        private String subscriptionStartDate;
        private String subscriptionEndDate;
        private String vpcId;
        private String subnetId;
        private String iamRoleArn;
        private String serialNumber;
        private String vendorName;
        private String hsmType;
        private String softwareVersion;
        private String sshPublicKey;
        private String sshKeyLastUpdated;
        private String serverCertUri;
        private String serverCertLastUpdated;
        private List<String> partitions = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmResponse model) {
            this.setHsmArn(model.hsmArn);
            this.setStatus(model.status);
            this.setStatusDetails(model.statusDetails);
            this.setAvailabilityZone(model.availabilityZone);
            this.setEniId(model.eniId);
            this.setEniIp(model.eniIp);
            this.setSubscriptionType(model.subscriptionType);
            this.setSubscriptionStartDate(model.subscriptionStartDate);
            this.setSubscriptionEndDate(model.subscriptionEndDate);
            this.setVpcId(model.vpcId);
            this.setSubnetId(model.subnetId);
            this.setIamRoleArn(model.iamRoleArn);
            this.setSerialNumber(model.serialNumber);
            this.setVendorName(model.vendorName);
            this.setHsmType(model.hsmType);
            this.setSoftwareVersion(model.softwareVersion);
            this.setSshPublicKey(model.sshPublicKey);
            this.setSshKeyLastUpdated(model.sshKeyLastUpdated);
            this.setServerCertUri(model.serverCertUri);
            this.setServerCertLastUpdated(model.serverCertLastUpdated);
            this.setPartitions(model.partitions);
        }

        public final String getHsmArn() {
            return this.hsmArn;
        }

        @Override
        public final Builder hsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
            return this;
        }

        public final void setHsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HsmStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(HsmStatus status) {
            this.status(status.toString());
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getEniId() {
            return this.eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        public final String getEniIp() {
            return this.eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        public final String getSubscriptionType() {
            return this.subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType.toString());
            return this;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public final void setSubscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType.toString());
        }

        public final String getSubscriptionStartDate() {
            return this.subscriptionStartDate;
        }

        @Override
        public final Builder subscriptionStartDate(String subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
            return this;
        }

        public final void setSubscriptionStartDate(String subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
        }

        public final String getSubscriptionEndDate() {
            return this.subscriptionEndDate;
        }

        @Override
        public final Builder subscriptionEndDate(String subscriptionEndDate) {
            this.subscriptionEndDate = subscriptionEndDate;
            return this;
        }

        public final void setSubscriptionEndDate(String subscriptionEndDate) {
            this.subscriptionEndDate = subscriptionEndDate;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final String getVendorName() {
            return this.vendorName;
        }

        @Override
        public final Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public final void setVendorName(String vendorName) {
            this.vendorName = vendorName;
        }

        public final String getHsmType() {
            return this.hsmType;
        }

        @Override
        public final Builder hsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        public final void setHsmType(String hsmType) {
            this.hsmType = hsmType;
        }

        public final String getSoftwareVersion() {
            return this.softwareVersion;
        }

        @Override
        public final Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public final void setSoftwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final String getSshKeyLastUpdated() {
            return this.sshKeyLastUpdated;
        }

        @Override
        public final Builder sshKeyLastUpdated(String sshKeyLastUpdated) {
            this.sshKeyLastUpdated = sshKeyLastUpdated;
            return this;
        }

        public final void setSshKeyLastUpdated(String sshKeyLastUpdated) {
            this.sshKeyLastUpdated = sshKeyLastUpdated;
        }

        public final String getServerCertUri() {
            return this.serverCertUri;
        }

        @Override
        public final Builder serverCertUri(String serverCertUri) {
            this.serverCertUri = serverCertUri;
            return this;
        }

        public final void setServerCertUri(String serverCertUri) {
            this.serverCertUri = serverCertUri;
        }

        public final String getServerCertLastUpdated() {
            return this.serverCertLastUpdated;
        }

        @Override
        public final Builder serverCertLastUpdated(String serverCertLastUpdated) {
            this.serverCertLastUpdated = serverCertLastUpdated;
            return this;
        }

        public final void setServerCertLastUpdated(String serverCertLastUpdated) {
            this.serverCertLastUpdated = serverCertLastUpdated;
        }

        public final Collection<String> getPartitions() {
            return this.partitions;
        }

        @Override
        public final Builder partitions(Collection<String> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(String ... partitions) {
            if (this.partitions == null) {
                this.partitions = new SdkInternalList(partitions.length);
            }
            for (String e : partitions) {
                this.partitions.add(e);
            }
            return this;
        }

        public final void setPartitions(Collection<String> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
        }

        @SafeVarargs
        public final void setPartitions(String ... partitions) {
            if (this.partitions == null) {
                this.partitions = new SdkInternalList(partitions.length);
            }
            for (String e : partitions) {
                this.partitions.add(e);
            }
        }

        public DescribeHsmResponse build() {
            return new DescribeHsmResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHsmResponse> {
        public Builder hsmArn(String var1);

        public Builder status(String var1);

        public Builder status(HsmStatus var1);

        public Builder statusDetails(String var1);

        public Builder availabilityZone(String var1);

        public Builder eniId(String var1);

        public Builder eniIp(String var1);

        public Builder subscriptionType(String var1);

        public Builder subscriptionType(SubscriptionType var1);

        public Builder subscriptionStartDate(String var1);

        public Builder subscriptionEndDate(String var1);

        public Builder vpcId(String var1);

        public Builder subnetId(String var1);

        public Builder iamRoleArn(String var1);

        public Builder serialNumber(String var1);

        public Builder vendorName(String var1);

        public Builder hsmType(String var1);

        public Builder softwareVersion(String var1);

        public Builder sshPublicKey(String var1);

        public Builder sshKeyLastUpdated(String var1);

        public Builder serverCertUri(String var1);

        public Builder serverCertLastUpdated(String var1);

        public Builder partitions(Collection<String> var1);

        public Builder partitions(String ... var1);
    }
}

