/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudhsm.model.Tag;
import software.amazon.awssdk.services.cloudhsm.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddTagsToResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddTagsToResourceRequest> {
    private final String resourceArn;
    private final List<Tag> tagList;

    private AddTagsToResourceRequest(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.tagList = builder.tagList;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public List<Tag> tagList() {
        return this.tagList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceArn() == null ? 0 : this.resourceArn().hashCode());
        hashCode = 31 * hashCode + (this.tagList() == null ? 0 : this.tagList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsToResourceRequest)) {
            return false;
        }
        AddTagsToResourceRequest other = (AddTagsToResourceRequest)((Object)obj);
        if (other.resourceArn() == null ^ this.resourceArn() == null) {
            return false;
        }
        if (other.resourceArn() != null && !other.resourceArn().equals(this.resourceArn())) {
            return false;
        }
        if (other.tagList() == null ^ this.tagList() == null) {
            return false;
        }
        return other.tagList() == null || other.tagList().equals(this.tagList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceArn() != null) {
            sb.append("ResourceArn: ").append(this.resourceArn()).append(",");
        }
        if (this.tagList() != null) {
            sb.append("TagList: ").append(this.tagList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<Tag> tagList = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsToResourceRequest model) {
            this.setResourceArn(model.resourceArn);
            this.setTagList(model.tagList);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<Tag> getTagList() {
            return this.tagList;
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            if (this.tagList == null) {
                this.tagList = new SdkInternalList(tagList.length);
            }
            for (Tag e : tagList) {
                this.tagList.add(e);
            }
            return this;
        }

        public final void setTagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        @SafeVarargs
        public final void setTagList(Tag ... tagList) {
            if (this.tagList == null) {
                this.tagList = new SdkInternalList(tagList.length);
            }
            for (Tag e : tagList) {
                this.tagList.add(e);
            }
        }

        public AddTagsToResourceRequest build() {
            return new AddTagsToResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddTagsToResourceRequest> {
        public Builder resourceArn(String var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);
    }
}

