/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPublicKeyConfigResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetPublicKeyConfigResponse.Builder, GetPublicKeyConfigResponse> {
    private static final SdkField<PublicKeyConfig> PUBLIC_KEY_CONFIG_FIELD = SdkField
            .<PublicKeyConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetPublicKeyConfigResponse::publicKeyConfig))
            .setter(setter(Builder::publicKeyConfig))
            .constructor(PublicKeyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyConfig")
                    .unmarshallLocationName("PublicKeyConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetPublicKeyConfigResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_CONFIG_FIELD,
            E_TAG_FIELD));

    private final PublicKeyConfig publicKeyConfig;

    private final String eTag;

    private GetPublicKeyConfigResponse(BuilderImpl builder) {
        super(builder);
        this.publicKeyConfig = builder.publicKeyConfig;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * Return the result for the public key configuration.
     * </p>
     * 
     * @return Return the result for the public key configuration.
     */
    public PublicKeyConfig publicKeyConfig() {
        return publicKeyConfig;
    }

    /**
     * <p>
     * The current version of the public key configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the public key configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPublicKeyConfigResponse)) {
            return false;
        }
        GetPublicKeyConfigResponse other = (GetPublicKeyConfigResponse) obj;
        return Objects.equals(publicKeyConfig(), other.publicKeyConfig()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPublicKeyConfigResponse").add("PublicKeyConfig", publicKeyConfig()).add("ETag", eTag())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicKeyConfig":
            return Optional.ofNullable(clazz.cast(publicKeyConfig()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPublicKeyConfigResponse, T> g) {
        return obj -> g.apply((GetPublicKeyConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPublicKeyConfigResponse> {
        /**
         * <p>
         * Return the result for the public key configuration.
         * </p>
         * 
         * @param publicKeyConfig
         *        Return the result for the public key configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyConfig(PublicKeyConfig publicKeyConfig);

        /**
         * <p>
         * Return the result for the public key configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link PublicKeyConfig.Builder} avoiding the need to
         * create one manually via {@link PublicKeyConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PublicKeyConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #publicKeyConfig(PublicKeyConfig)}.
         * 
         * @param publicKeyConfig
         *        a consumer that will call methods on {@link PublicKeyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicKeyConfig(PublicKeyConfig)
         */
        default Builder publicKeyConfig(Consumer<PublicKeyConfig.Builder> publicKeyConfig) {
            return publicKeyConfig(PublicKeyConfig.builder().applyMutation(publicKeyConfig).build());
        }

        /**
         * <p>
         * The current version of the public key configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the public key configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private PublicKeyConfig publicKeyConfig;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPublicKeyConfigResponse model) {
            super(model);
            publicKeyConfig(model.publicKeyConfig);
            eTag(model.eTag);
        }

        public final PublicKeyConfig.Builder getPublicKeyConfig() {
            return publicKeyConfig != null ? publicKeyConfig.toBuilder() : null;
        }

        @Override
        public final Builder publicKeyConfig(PublicKeyConfig publicKeyConfig) {
            this.publicKeyConfig = publicKeyConfig;
            return this;
        }

        public final void setPublicKeyConfig(PublicKeyConfig.BuilderImpl publicKeyConfig) {
            this.publicKeyConfig = publicKeyConfig != null ? publicKeyConfig.build() : null;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetPublicKeyConfigResponse build() {
            return new GetPublicKeyConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
