/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.InvalidationList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInvalidationsResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListInvalidationsResponse> {
    private static final SdkField<InvalidationList> INVALIDATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListInvalidationsResponse.getter(ListInvalidationsResponse::invalidationList)).setter(ListInvalidationsResponse.setter(Builder::invalidationList)).constructor(InvalidationList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidationList").unmarshallLocationName("InvalidationList").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALIDATION_LIST_FIELD));
    private final InvalidationList invalidationList;

    private ListInvalidationsResponse(BuilderImpl builder) {
        super(builder);
        this.invalidationList = builder.invalidationList;
    }

    public InvalidationList invalidationList() {
        return this.invalidationList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidationList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvalidationsResponse)) {
            return false;
        }
        ListInvalidationsResponse other = (ListInvalidationsResponse)((Object)obj);
        return Objects.equals(this.invalidationList(), other.invalidationList());
    }

    public String toString() {
        return ToString.builder((String)"ListInvalidationsResponse").add("InvalidationList", (Object)this.invalidationList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvalidationList": {
                return Optional.ofNullable(clazz.cast(this.invalidationList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInvalidationsResponse, T> g) {
        return obj -> g.apply((ListInvalidationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private InvalidationList invalidationList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvalidationsResponse model) {
            super(model);
            this.invalidationList(model.invalidationList);
        }

        public final InvalidationList.Builder getInvalidationList() {
            return this.invalidationList != null ? this.invalidationList.toBuilder() : null;
        }

        @Override
        public final Builder invalidationList(InvalidationList invalidationList) {
            this.invalidationList = invalidationList;
            return this;
        }

        public final void setInvalidationList(InvalidationList.BuilderImpl invalidationList) {
            this.invalidationList = invalidationList != null ? invalidationList.build() : null;
        }

        @Override
        public ListInvalidationsResponse build() {
            return new ListInvalidationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInvalidationsResponse> {
        public Builder invalidationList(InvalidationList var1);

        default public Builder invalidationList(Consumer<InvalidationList.Builder> invalidationList) {
            return this.invalidationList((InvalidationList)((InvalidationList.Builder)InvalidationList.builder().applyMutation(invalidationList)).build());
        }
    }
}

