/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.TrustStoreListCopier;
import software.amazon.awssdk.services.cloudfront.model.TrustStoreSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrustStoresResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListTrustStoresResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListTrustStoresResponse.getter(ListTrustStoresResponse::nextMarker)).setter(ListTrustStoresResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").unmarshallLocationName("NextMarker").build()}).build();
    private static final SdkField<List<TrustStoreSummary>> TRUST_STORE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrustStoreList").getter(ListTrustStoresResponse.getter(ListTrustStoresResponse::trustStoreList)).setter(ListTrustStoresResponse.setter(Builder::trustStoreList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreList").unmarshallLocationName("TrustStoreList").build(), ListTrait.builder().memberLocationName("TrustStoreSummary").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrustStoreSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreSummary").unmarshallLocationName("TrustStoreSummary").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, TRUST_STORE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTrustStoresResponse.memberNameToFieldInitializer();
    private final String nextMarker;
    private final List<TrustStoreSummary> trustStoreList;

    private ListTrustStoresResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.trustStoreList = builder.trustStoreList;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasTrustStoreList() {
        return this.trustStoreList != null && !(this.trustStoreList instanceof SdkAutoConstructList);
    }

    public final List<TrustStoreSummary> trustStoreList() {
        return this.trustStoreList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrustStoreList() ? this.trustStoreList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrustStoresResponse)) {
            return false;
        }
        ListTrustStoresResponse other = (ListTrustStoresResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasTrustStoreList() == other.hasTrustStoreList() && Objects.equals(this.trustStoreList(), other.trustStoreList());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrustStoresResponse").add("NextMarker", (Object)this.nextMarker()).add("TrustStoreList", this.hasTrustStoreList() ? this.trustStoreList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "TrustStoreList": {
                return Optional.ofNullable(clazz.cast(this.trustStoreList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("TrustStoreList", TRUST_STORE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrustStoresResponse, T> g) {
        return obj -> g.apply((ListTrustStoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<TrustStoreSummary> trustStoreList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrustStoresResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.trustStoreList(model.trustStoreList);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<TrustStoreSummary.Builder> getTrustStoreList() {
            List<TrustStoreSummary.Builder> result = TrustStoreListCopier.copyToBuilder(this.trustStoreList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrustStoreList(Collection<TrustStoreSummary.BuilderImpl> trustStoreList) {
            this.trustStoreList = TrustStoreListCopier.copyFromBuilder(trustStoreList);
        }

        @Override
        public final Builder trustStoreList(Collection<TrustStoreSummary> trustStoreList) {
            this.trustStoreList = TrustStoreListCopier.copy(trustStoreList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustStoreList(TrustStoreSummary ... trustStoreList) {
            this.trustStoreList(Arrays.asList(trustStoreList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustStoreList(Consumer<TrustStoreSummary.Builder> ... trustStoreList) {
            this.trustStoreList(Stream.of(trustStoreList).map(c -> (TrustStoreSummary)((TrustStoreSummary.Builder)TrustStoreSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrustStoresResponse build() {
            return new ListTrustStoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrustStoresResponse> {
        public Builder nextMarker(String var1);

        public Builder trustStoreList(Collection<TrustStoreSummary> var1);

        public Builder trustStoreList(TrustStoreSummary ... var1);

        public Builder trustStoreList(Consumer<TrustStoreSummary.Builder> ... var1);
    }
}

