/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContinuousDeploymentPolicyResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, CreateContinuousDeploymentPolicyResponse> {
    private static final SdkField<ContinuousDeploymentPolicy> CONTINUOUS_DEPLOYMENT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContinuousDeploymentPolicy").getter(CreateContinuousDeploymentPolicyResponse.getter(CreateContinuousDeploymentPolicyResponse::continuousDeploymentPolicy)).setter(CreateContinuousDeploymentPolicyResponse.setter(Builder::continuousDeploymentPolicy)).constructor(ContinuousDeploymentPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousDeploymentPolicy").unmarshallLocationName("ContinuousDeploymentPolicy").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(CreateContinuousDeploymentPolicyResponse.getter(CreateContinuousDeploymentPolicyResponse::location)).setter(CreateContinuousDeploymentPolicyResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(CreateContinuousDeploymentPolicyResponse.getter(CreateContinuousDeploymentPolicyResponse::eTag)).setter(CreateContinuousDeploymentPolicyResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINUOUS_DEPLOYMENT_POLICY_FIELD, LOCATION_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateContinuousDeploymentPolicyResponse.memberNameToFieldInitializer();
    private final ContinuousDeploymentPolicy continuousDeploymentPolicy;
    private final String location;
    private final String eTag;

    private CreateContinuousDeploymentPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.continuousDeploymentPolicy = builder.continuousDeploymentPolicy;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    public final ContinuousDeploymentPolicy continuousDeploymentPolicy() {
        return this.continuousDeploymentPolicy;
    }

    public final String location() {
        return this.location;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.continuousDeploymentPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContinuousDeploymentPolicyResponse)) {
            return false;
        }
        CreateContinuousDeploymentPolicyResponse other = (CreateContinuousDeploymentPolicyResponse)((Object)obj);
        return Objects.equals(this.continuousDeploymentPolicy(), other.continuousDeploymentPolicy()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContinuousDeploymentPolicyResponse").add("ContinuousDeploymentPolicy", (Object)this.continuousDeploymentPolicy()).add("Location", (Object)this.location()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContinuousDeploymentPolicy": {
                return Optional.ofNullable(clazz.cast(this.continuousDeploymentPolicy()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContinuousDeploymentPolicy", CONTINUOUS_DEPLOYMENT_POLICY_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContinuousDeploymentPolicyResponse, T> g) {
        return obj -> g.apply((CreateContinuousDeploymentPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private ContinuousDeploymentPolicy continuousDeploymentPolicy;
        private String location;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContinuousDeploymentPolicyResponse model) {
            super(model);
            this.continuousDeploymentPolicy(model.continuousDeploymentPolicy);
            this.location(model.location);
            this.eTag(model.eTag);
        }

        public final ContinuousDeploymentPolicy.Builder getContinuousDeploymentPolicy() {
            return this.continuousDeploymentPolicy != null ? this.continuousDeploymentPolicy.toBuilder() : null;
        }

        public final void setContinuousDeploymentPolicy(ContinuousDeploymentPolicy.BuilderImpl continuousDeploymentPolicy) {
            this.continuousDeploymentPolicy = continuousDeploymentPolicy != null ? continuousDeploymentPolicy.build() : null;
        }

        @Override
        public final Builder continuousDeploymentPolicy(ContinuousDeploymentPolicy continuousDeploymentPolicy) {
            this.continuousDeploymentPolicy = continuousDeploymentPolicy;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public CreateContinuousDeploymentPolicyResponse build() {
            return new CreateContinuousDeploymentPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContinuousDeploymentPolicyResponse> {
        public Builder continuousDeploymentPolicy(ContinuousDeploymentPolicy var1);

        default public Builder continuousDeploymentPolicy(Consumer<ContinuousDeploymentPolicy.Builder> continuousDeploymentPolicy) {
            return this.continuousDeploymentPolicy((ContinuousDeploymentPolicy)((ContinuousDeploymentPolicy.Builder)ContinuousDeploymentPolicy.builder().applyMutation(continuousDeploymentPolicy)).build());
        }

        public Builder location(String var1);

        public Builder eTag(String var1);
    }
}

