/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The key value store association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyValueStoreAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<KeyValueStoreAssociation.Builder, KeyValueStoreAssociation> {
    private static final SdkField<String> KEY_VALUE_STORE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyValueStoreARN")
            .getter(getter(KeyValueStoreAssociation::keyValueStoreARN))
            .setter(setter(Builder::keyValueStoreARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyValueStoreARN")
                    .unmarshallLocationName("KeyValueStoreARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_VALUE_STORE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyValueStoreARN;

    private KeyValueStoreAssociation(BuilderImpl builder) {
        this.keyValueStoreARN = builder.keyValueStoreARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the key value store association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the key value store association.
     */
    public final String keyValueStoreARN() {
        return keyValueStoreARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyValueStoreARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyValueStoreAssociation)) {
            return false;
        }
        KeyValueStoreAssociation other = (KeyValueStoreAssociation) obj;
        return Objects.equals(keyValueStoreARN(), other.keyValueStoreARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyValueStoreAssociation").add("KeyValueStoreARN", keyValueStoreARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyValueStoreARN":
            return Optional.ofNullable(clazz.cast(keyValueStoreARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyValueStoreARN", KEY_VALUE_STORE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyValueStoreAssociation, T> g) {
        return obj -> g.apply((KeyValueStoreAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyValueStoreAssociation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the key value store association.
         * </p>
         * 
         * @param keyValueStoreARN
         *        The Amazon Resource Name (ARN) of the key value store association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValueStoreARN(String keyValueStoreARN);
    }

    static final class BuilderImpl implements Builder {
        private String keyValueStoreARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyValueStoreAssociation model) {
            keyValueStoreARN(model.keyValueStoreARN);
        }

        public final String getKeyValueStoreARN() {
            return keyValueStoreARN;
        }

        public final void setKeyValueStoreARN(String keyValueStoreARN) {
            this.keyValueStoreARN = keyValueStoreARN;
        }

        @Override
        public final Builder keyValueStoreARN(String keyValueStoreARN) {
            this.keyValueStoreARN = keyValueStoreARN;
            return this;
        }

        @Override
        public KeyValueStoreAssociation build() {
            return new KeyValueStoreAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
