/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DnsConfigurationStatus {
    VALID_CONFIGURATION("valid-configuration"),
    INVALID_CONFIGURATION("invalid-configuration"),
    UNKNOWN_CONFIGURATION("unknown-configuration"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DnsConfigurationStatus> VALUE_MAP;
    private final String value;

    private DnsConfigurationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DnsConfigurationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DnsConfigurationStatus> knownValues() {
        EnumSet<DnsConfigurationStatus> knownValues = EnumSet.allOf(DnsConfigurationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DnsConfigurationStatus.class, DnsConfigurationStatus::toString);
    }
}

