/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePublicKeyResponse extends CloudFrontResponse implements
        ToCopyableBuilder<CreatePublicKeyResponse.Builder, CreatePublicKeyResponse> {
    private static final SdkField<PublicKey> PUBLIC_KEY_FIELD = SdkField
            .<PublicKey> builder(MarshallingType.SDK_POJO)
            .memberName("PublicKey")
            .getter(getter(CreatePublicKeyResponse::publicKey))
            .setter(setter(Builder::publicKey))
            .constructor(PublicKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey")
                    .unmarshallLocationName("PublicKey").build(), PayloadTrait.create()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(CreatePublicKeyResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(CreatePublicKeyResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_FIELD,
            LOCATION_FIELD, E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PublicKey publicKey;

    private final String location;

    private final String eTag;

    private CreatePublicKeyResponse(BuilderImpl builder) {
        super(builder);
        this.publicKey = builder.publicKey;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The public key.
     * </p>
     * 
     * @return The public key.
     */
    public final PublicKey publicKey() {
        return publicKey;
    }

    /**
     * <p>
     * The URL of the public key.
     * </p>
     * 
     * @return The URL of the public key.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The identifier for this version of the public key.
     * </p>
     * 
     * @return The identifier for this version of the public key.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePublicKeyResponse)) {
            return false;
        }
        CreatePublicKeyResponse other = (CreatePublicKeyResponse) obj;
        return Objects.equals(publicKey(), other.publicKey()) && Objects.equals(location(), other.location())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePublicKeyResponse").add("PublicKey", publicKey()).add("Location", location())
                .add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicKey":
            return Optional.ofNullable(clazz.cast(publicKey()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PublicKey", PUBLIC_KEY_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePublicKeyResponse, T> g) {
        return obj -> g.apply((CreatePublicKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePublicKeyResponse> {
        /**
         * <p>
         * The public key.
         * </p>
         * 
         * @param publicKey
         *        The public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKey(PublicKey publicKey);

        /**
         * <p>
         * The public key.
         * </p>
         * This is a convenience method that creates an instance of the {@link PublicKey.Builder} avoiding the need to
         * create one manually via {@link PublicKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PublicKey.Builder#build()} is called immediately and its result
         * is passed to {@link #publicKey(PublicKey)}.
         * 
         * @param publicKey
         *        a consumer that will call methods on {@link PublicKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicKey(PublicKey)
         */
        default Builder publicKey(Consumer<PublicKey.Builder> publicKey) {
            return publicKey(PublicKey.builder().applyMutation(publicKey).build());
        }

        /**
         * <p>
         * The URL of the public key.
         * </p>
         * 
         * @param location
         *        The URL of the public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The identifier for this version of the public key.
         * </p>
         * 
         * @param eTag
         *        The identifier for this version of the public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private PublicKey publicKey;

        private String location;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePublicKeyResponse model) {
            super(model);
            publicKey(model.publicKey);
            location(model.location);
            eTag(model.eTag);
        }

        public final PublicKey.Builder getPublicKey() {
            return publicKey != null ? publicKey.toBuilder() : null;
        }

        public final void setPublicKey(PublicKey.BuilderImpl publicKey) {
            this.publicKey = publicKey != null ? publicKey.build() : null;
        }

        @Override
        public final Builder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public CreatePublicKeyResponse build() {
            return new CreatePublicKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
