/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary that contains details about your connection groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionGroupSummary.Builder, ConnectionGroupSummary> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(ConnectionGroupSummary::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(ConnectionGroupSummary::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Arn")
            .getter(getter(ConnectionGroupSummary::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn")
                    .build()).build();

    private static final SdkField<String> ROUTING_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RoutingEndpoint")
            .getter(getter(ConnectionGroupSummary::routingEndpoint))
            .setter(setter(Builder::routingEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingEndpoint")
                    .unmarshallLocationName("RoutingEndpoint").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime")
            .getter(getter(ConnectionGroupSummary::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime")
                    .unmarshallLocationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(ConnectionGroupSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(ConnectionGroupSummary::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag")
                    .unmarshallLocationName("ETag").build()).build();

    private static final SdkField<String> ANYCAST_IP_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnycastIpListId")
            .getter(getter(ConnectionGroupSummary::anycastIpListId))
            .setter(setter(Builder::anycastIpListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIpListId")
                    .unmarshallLocationName("AnycastIpListId").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(ConnectionGroupSummary::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(ConnectionGroupSummary::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault")
            .getter(getter(ConnectionGroupSummary::isDefault))
            .setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault")
                    .unmarshallLocationName("IsDefault").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, ROUTING_ENDPOINT_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, E_TAG_FIELD,
            ANYCAST_IP_LIST_ID_FIELD, ENABLED_FIELD, STATUS_FIELD, IS_DEFAULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String arn;

    private final String routingEndpoint;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private final String eTag;

    private final String anycastIpListId;

    private final Boolean enabled;

    private final String status;

    private final Boolean isDefault;

    private ConnectionGroupSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.routingEndpoint = builder.routingEndpoint;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.eTag = builder.eTag;
        this.anycastIpListId = builder.anycastIpListId;
        this.enabled = builder.enabled;
        this.status = builder.status;
        this.isDefault = builder.isDefault;
    }

    /**
     * <p>
     * The ID of the connection group.
     * </p>
     * 
     * @return The ID of the connection group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the connection group.
     * </p>
     * 
     * @return The name of the connection group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connection group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connection group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The routing endpoint (also known as the DNS name) that is assigned to the connection group, such as
     * d111111abcdef8.cloudfront.net.
     * </p>
     * 
     * @return The routing endpoint (also known as the DNS name) that is assigned to the connection group, such as
     *         d111111abcdef8.cloudfront.net.
     */
    public final String routingEndpoint() {
        return routingEndpoint;
    }

    /**
     * <p>
     * The date and time when the connection group was created.
     * </p>
     * 
     * @return The date and time when the connection group was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date and time when the connection group was updated.
     * </p>
     * 
     * @return The date and time when the connection group was updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The current version of the connection group.
     * </p>
     * 
     * @return The current version of the connection group.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * <p>
     * The ID of the Anycast static IP list.
     * </p>
     * 
     * @return The ID of the Anycast static IP list.
     */
    public final String anycastIpListId() {
        return anycastIpListId;
    }

    /**
     * <p>
     * Whether the connection group is enabled
     * </p>
     * 
     * @return Whether the connection group is enabled
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The status of the connection group.
     * </p>
     * 
     * @return The status of the connection group.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Whether the connection group is the default connection group for the distribution tenants.
     * </p>
     * 
     * @return Whether the connection group is the default connection group for the distribution tenants.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(routingEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(anycastIpListId());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionGroupSummary)) {
            return false;
        }
        ConnectionGroupSummary other = (ConnectionGroupSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(routingEndpoint(), other.routingEndpoint())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(eTag(), other.eTag())
                && Objects.equals(anycastIpListId(), other.anycastIpListId()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(status(), other.status()) && Objects.equals(isDefault(), other.isDefault());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionGroupSummary").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("RoutingEndpoint", routingEndpoint()).add("CreatedTime", createdTime())
                .add("LastModifiedTime", lastModifiedTime()).add("ETag", eTag()).add("AnycastIpListId", anycastIpListId())
                .add("Enabled", enabled()).add("Status", status()).add("IsDefault", isDefault()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "RoutingEndpoint":
            return Optional.ofNullable(clazz.cast(routingEndpoint()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "AnycastIpListId":
            return Optional.ofNullable(clazz.cast(anycastIpListId()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("RoutingEndpoint", ROUTING_ENDPOINT_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("AnycastIpListId", ANYCAST_IP_LIST_ID_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("IsDefault", IS_DEFAULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionGroupSummary, T> g) {
        return obj -> g.apply((ConnectionGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionGroupSummary> {
        /**
         * <p>
         * The ID of the connection group.
         * </p>
         * 
         * @param id
         *        The ID of the connection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the connection group.
         * </p>
         * 
         * @param name
         *        The name of the connection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connection group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the connection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The routing endpoint (also known as the DNS name) that is assigned to the connection group, such as
         * d111111abcdef8.cloudfront.net.
         * </p>
         * 
         * @param routingEndpoint
         *        The routing endpoint (also known as the DNS name) that is assigned to the connection group, such as
         *        d111111abcdef8.cloudfront.net.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingEndpoint(String routingEndpoint);

        /**
         * <p>
         * The date and time when the connection group was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time when the connection group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The date and time when the connection group was updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time when the connection group was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The current version of the connection group.
         * </p>
         * 
         * @param eTag
         *        The current version of the connection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * The ID of the Anycast static IP list.
         * </p>
         * 
         * @param anycastIpListId
         *        The ID of the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anycastIpListId(String anycastIpListId);

        /**
         * <p>
         * Whether the connection group is enabled
         * </p>
         * 
         * @param enabled
         *        Whether the connection group is enabled
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The status of the connection group.
         * </p>
         * 
         * @param status
         *        The status of the connection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Whether the connection group is the default connection group for the distribution tenants.
         * </p>
         * 
         * @param isDefault
         *        Whether the connection group is the default connection group for the distribution tenants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private String routingEndpoint;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private String eTag;

        private String anycastIpListId;

        private Boolean enabled;

        private String status;

        private Boolean isDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionGroupSummary model) {
            id(model.id);
            name(model.name);
            arn(model.arn);
            routingEndpoint(model.routingEndpoint);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
            eTag(model.eTag);
            anycastIpListId(model.anycastIpListId);
            enabled(model.enabled);
            status(model.status);
            isDefault(model.isDefault);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRoutingEndpoint() {
            return routingEndpoint;
        }

        public final void setRoutingEndpoint(String routingEndpoint) {
            this.routingEndpoint = routingEndpoint;
        }

        @Override
        public final Builder routingEndpoint(String routingEndpoint) {
            this.routingEndpoint = routingEndpoint;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getAnycastIpListId() {
            return anycastIpListId;
        }

        public final void setAnycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
        }

        @Override
        public final Builder anycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @Override
        public ConnectionGroupSummary build() {
            return new ConnectionGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
