/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInvalidationForDistributionTenantResponse extends CloudFrontResponse
        implements
        ToCopyableBuilder<CreateInvalidationForDistributionTenantResponse.Builder, CreateInvalidationForDistributionTenantResponse> {
    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(CreateInvalidationForDistributionTenantResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final SdkField<Invalidation> INVALIDATION_FIELD = SdkField
            .<Invalidation> builder(MarshallingType.SDK_POJO)
            .memberName("Invalidation")
            .getter(getter(CreateInvalidationForDistributionTenantResponse::invalidation))
            .setter(setter(Builder::invalidation))
            .constructor(Invalidation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Invalidation")
                    .unmarshallLocationName("Invalidation").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD,
            INVALIDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String location;

    private final Invalidation invalidation;

    private CreateInvalidationForDistributionTenantResponse(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.invalidation = builder.invalidation;
    }

    /**
     * <p>
     * The location for the invalidation.
     * </p>
     * 
     * @return The location for the invalidation.
     */
    public final String location() {
        return location;
    }

    /**
     * Returns the value of the Invalidation property for this object.
     * 
     * @return The value of the Invalidation property for this object.
     */
    public final Invalidation invalidation() {
        return invalidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(invalidation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvalidationForDistributionTenantResponse)) {
            return false;
        }
        CreateInvalidationForDistributionTenantResponse other = (CreateInvalidationForDistributionTenantResponse) obj;
        return Objects.equals(location(), other.location()) && Objects.equals(invalidation(), other.invalidation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInvalidationForDistributionTenantResponse").add("Location", location())
                .add("Invalidation", invalidation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Invalidation":
            return Optional.ofNullable(clazz.cast(invalidation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Location", LOCATION_FIELD);
        map.put("Invalidation", INVALIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInvalidationForDistributionTenantResponse, T> g) {
        return obj -> g.apply((CreateInvalidationForDistributionTenantResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateInvalidationForDistributionTenantResponse> {
        /**
         * <p>
         * The location for the invalidation.
         * </p>
         * 
         * @param location
         *        The location for the invalidation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * Sets the value of the Invalidation property for this object.
         *
         * @param invalidation
         *        The new value for the Invalidation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidation(Invalidation invalidation);

        /**
         * Sets the value of the Invalidation property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Invalidation.Builder} avoiding the need
         * to create one manually via {@link Invalidation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Invalidation.Builder#build()} is called immediately and its
         * result is passed to {@link #invalidation(Invalidation)}.
         * 
         * @param invalidation
         *        a consumer that will call methods on {@link Invalidation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidation(Invalidation)
         */
        default Builder invalidation(Consumer<Invalidation.Builder> invalidation) {
            return invalidation(Invalidation.builder().applyMutation(invalidation).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private String location;

        private Invalidation invalidation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvalidationForDistributionTenantResponse model) {
            super(model);
            location(model.location);
            invalidation(model.invalidation);
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final Invalidation.Builder getInvalidation() {
            return invalidation != null ? invalidation.toBuilder() : null;
        }

        public final void setInvalidation(Invalidation.BuilderImpl invalidation) {
            this.invalidation = invalidation != null ? invalidation.build() : null;
        }

        @Override
        public final Builder invalidation(Invalidation invalidation) {
            this.invalidation = invalidation;
            return this;
        }

        @Override
        public CreateInvalidationForDistributionTenantResponse build() {
            return new CreateInvalidationForDistributionTenantResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
