/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus;
import software.amazon.awssdk.services.cloudfront.model.ValidationTokenDetail;
import software.amazon.awssdk.services.cloudfront.model.ValidationTokenDetailListCopier;
import software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedCertificateDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedCertificateDetails> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(ManagedCertificateDetails.getter(ManagedCertificateDetails::certificateArn)).setter(ManagedCertificateDetails.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").unmarshallLocationName("CertificateArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateStatus").getter(ManagedCertificateDetails.getter(ManagedCertificateDetails::certificateStatusAsString)).setter(ManagedCertificateDetails.setter(Builder::certificateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateStatus").unmarshallLocationName("CertificateStatus").build()}).build();
    private static final SdkField<String> VALIDATION_TOKEN_HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationTokenHost").getter(ManagedCertificateDetails.getter(ManagedCertificateDetails::validationTokenHostAsString)).setter(ManagedCertificateDetails.setter(Builder::validationTokenHost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationTokenHost").unmarshallLocationName("ValidationTokenHost").build()}).build();
    private static final SdkField<List<ValidationTokenDetail>> VALIDATION_TOKEN_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidationTokenDetails").getter(ManagedCertificateDetails.getter(ManagedCertificateDetails::validationTokenDetails)).setter(ManagedCertificateDetails.setter(Builder::validationTokenDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationTokenDetails").unmarshallLocationName("ValidationTokenDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationTokenDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, CERTIFICATE_STATUS_FIELD, VALIDATION_TOKEN_HOST_FIELD, VALIDATION_TOKEN_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedCertificateDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String certificateArn;
    private final String certificateStatus;
    private final String validationTokenHost;
    private final List<ValidationTokenDetail> validationTokenDetails;

    private ManagedCertificateDetails(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateStatus = builder.certificateStatus;
        this.validationTokenHost = builder.validationTokenHost;
        this.validationTokenDetails = builder.validationTokenDetails;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final ManagedCertificateStatus certificateStatus() {
        return ManagedCertificateStatus.fromValue(this.certificateStatus);
    }

    public final String certificateStatusAsString() {
        return this.certificateStatus;
    }

    public final ValidationTokenHost validationTokenHost() {
        return ValidationTokenHost.fromValue(this.validationTokenHost);
    }

    public final String validationTokenHostAsString() {
        return this.validationTokenHost;
    }

    public final boolean hasValidationTokenDetails() {
        return this.validationTokenDetails != null && !(this.validationTokenDetails instanceof SdkAutoConstructList);
    }

    public final List<ValidationTokenDetail> validationTokenDetails() {
        return this.validationTokenDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationTokenHostAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationTokenDetails() ? this.validationTokenDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedCertificateDetails)) {
            return false;
        }
        ManagedCertificateDetails other = (ManagedCertificateDetails)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateStatusAsString(), other.certificateStatusAsString()) && Objects.equals(this.validationTokenHostAsString(), other.validationTokenHostAsString()) && this.hasValidationTokenDetails() == other.hasValidationTokenDetails() && Objects.equals(this.validationTokenDetails(), other.validationTokenDetails());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedCertificateDetails").add("CertificateArn", (Object)this.certificateArn()).add("CertificateStatus", (Object)this.certificateStatusAsString()).add("ValidationTokenHost", (Object)this.validationTokenHostAsString()).add("ValidationTokenDetails", this.hasValidationTokenDetails() ? this.validationTokenDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "CertificateStatus": {
                return Optional.ofNullable(clazz.cast(this.certificateStatusAsString()));
            }
            case "ValidationTokenHost": {
                return Optional.ofNullable(clazz.cast(this.validationTokenHostAsString()));
            }
            case "ValidationTokenDetails": {
                return Optional.ofNullable(clazz.cast(this.validationTokenDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CertificateArn", CERTIFICATE_ARN_FIELD);
        map.put("CertificateStatus", CERTIFICATE_STATUS_FIELD);
        map.put("ValidationTokenHost", VALIDATION_TOKEN_HOST_FIELD);
        map.put("ValidationTokenDetails", VALIDATION_TOKEN_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedCertificateDetails, T> g) {
        return obj -> g.apply((ManagedCertificateDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String certificateStatus;
        private String validationTokenHost;
        private List<ValidationTokenDetail> validationTokenDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedCertificateDetails model) {
            this.certificateArn(model.certificateArn);
            this.certificateStatus(model.certificateStatus);
            this.validationTokenHost(model.validationTokenHost);
            this.validationTokenDetails(model.validationTokenDetails);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getCertificateStatus() {
            return this.certificateStatus;
        }

        public final void setCertificateStatus(String certificateStatus) {
            this.certificateStatus = certificateStatus;
        }

        @Override
        public final Builder certificateStatus(String certificateStatus) {
            this.certificateStatus = certificateStatus;
            return this;
        }

        @Override
        public final Builder certificateStatus(ManagedCertificateStatus certificateStatus) {
            this.certificateStatus(certificateStatus == null ? null : certificateStatus.toString());
            return this;
        }

        public final String getValidationTokenHost() {
            return this.validationTokenHost;
        }

        public final void setValidationTokenHost(String validationTokenHost) {
            this.validationTokenHost = validationTokenHost;
        }

        @Override
        public final Builder validationTokenHost(String validationTokenHost) {
            this.validationTokenHost = validationTokenHost;
            return this;
        }

        @Override
        public final Builder validationTokenHost(ValidationTokenHost validationTokenHost) {
            this.validationTokenHost(validationTokenHost == null ? null : validationTokenHost.toString());
            return this;
        }

        public final List<ValidationTokenDetail.Builder> getValidationTokenDetails() {
            List<ValidationTokenDetail.Builder> result = ValidationTokenDetailListCopier.copyToBuilder(this.validationTokenDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationTokenDetails(Collection<ValidationTokenDetail.BuilderImpl> validationTokenDetails) {
            this.validationTokenDetails = ValidationTokenDetailListCopier.copyFromBuilder(validationTokenDetails);
        }

        @Override
        public final Builder validationTokenDetails(Collection<ValidationTokenDetail> validationTokenDetails) {
            this.validationTokenDetails = ValidationTokenDetailListCopier.copy(validationTokenDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationTokenDetails(ValidationTokenDetail ... validationTokenDetails) {
            this.validationTokenDetails(Arrays.asList(validationTokenDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationTokenDetails(Consumer<ValidationTokenDetail.Builder> ... validationTokenDetails) {
            this.validationTokenDetails(Stream.of(validationTokenDetails).map(c -> (ValidationTokenDetail)((ValidationTokenDetail.Builder)ValidationTokenDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ManagedCertificateDetails build() {
            return new ManagedCertificateDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedCertificateDetails> {
        public Builder certificateArn(String var1);

        public Builder certificateStatus(String var1);

        public Builder certificateStatus(ManagedCertificateStatus var1);

        public Builder validationTokenHost(String var1);

        public Builder validationTokenHost(ValidationTokenHost var1);

        public Builder validationTokenDetails(Collection<ValidationTokenDetail> var1);

        public Builder validationTokenDetails(ValidationTokenDetail ... var1);

        public Builder validationTokenDetails(Consumer<ValidationTokenDetail.Builder> ... var1);
    }
}

